/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.signal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import net.infonode.util.collection.CopyOnWriteArrayList;
import net.infonode.util.collection.EmptyIterator;
import net.infonode.util.signal.SignalHook;
import net.infonode.util.signal.SignalListener;

public class Signal {
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private boolean reverseNotifyOrder;
    private CopyOnWriteArrayList listeners;
    private SignalHookImpl signalHook = new SignalHookImpl();

    public Signal() {
        this(true);
    }

    public Signal(boolean bl) {
        this.reverseNotifyOrder = bl;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public synchronized void addListener(SignalListener signalListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList(2);
        }
        this.listeners.add(signalListener);
        if (this.listeners.size() == 1) {
            this.firstListenerAdded();
        }
    }

    public synchronized boolean removeListener(SignalListener signalListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object object = this.listeners.get(i);
                if (object != signalListener && (!(object instanceof WeakListener) || ((WeakListener)object).get() != signalListener)) continue;
                this.removeListener(i);
                return true;
            }
        }
        return false;
    }

    protected synchronized void removeWeakListener(WeakListener weakListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object object = this.listeners.get(i);
                if (object != weakListener) continue;
                this.removeListener(i);
                break;
            }
        }
    }

    protected synchronized void removeListener(int n) {
        this.listeners.remove(n);
        if (this.listeners.size() == 0) {
            this.listeners = null;
            this.lastListenerRemoved();
        }
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public synchronized Iterator iterator() {
        return this.listeners == null ? EmptyIterator.INSTANCE : this.listeners.iterator();
    }

    public SignalHook getHook() {
        return this.signalHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void emit(Object object) {
        int n;
        Object[] objectArray;
        Signal signal = this;
        synchronized (signal) {
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getElements();
            n = this.listeners.size();
        }
        if (this.reverseNotifyOrder) {
            for (int i = n - 1; i >= 0; --i) {
                ((SignalListener)objectArray[i]).signalEmitted(this, object);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ((SignalListener)objectArray[i]).signalEmitted(this, object);
            }
        }
    }

    public void removeListeners(Collection collection) {
        this.listeners.removeAll(collection);
    }

    static {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        ((WeakListener)refQueue.remove()).remove();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private class SignalHookImpl
    implements SignalHook {
        private SignalHookImpl() {
        }

        public void add(SignalListener signalListener) {
            Signal.this.addListener(signalListener);
        }

        public void addWeak(SignalListener signalListener) {
            Signal.this.addListener(new WeakListener(signalListener, refQueue, this));
        }

        public boolean remove(SignalListener signalListener) {
            return Signal.this.removeListener(signalListener);
        }

        public void removeWeak(WeakListener weakListener) {
            Signal.this.removeWeakListener(weakListener);
        }
    }

    private static class WeakListener
    extends WeakReference
    implements SignalListener {
        private SignalHookImpl hook;

        protected WeakListener(SignalListener signalListener, ReferenceQueue referenceQueue, SignalHookImpl signalHookImpl) {
            super(signalListener, referenceQueue);
            this.hook = signalHookImpl;
        }

        public void remove() {
            this.hook.removeWeak(this);
        }

        public void signalEmitted(Signal signal, Object object) {
            SignalListener signalListener = (SignalListener)this.get();
            if (signalListener != null) {
                signalListener.signalEmitted(signal, object);
            }
        }
    }
}

