/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.WindowTabState;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.docking.properties.WindowTabStateProperties;
import net.infonode.gui.ContainerList;
import net.infonode.gui.panel.DirectionPanel;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Direction;

class WindowTab
extends TitledTab {
    private static final TitledTabStateProperties EMPTY_PROPERTIES = new TitledTabStateProperties();
    private static final WindowTabProperties EMPTY_TAB_PROPERTIES = new WindowTabProperties();
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(WindowTabStateProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(WindowTabStateProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(WindowTabStateProperties.MINIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(WindowTabStateProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(WindowTabStateProperties.CLOSE_BUTTON_PROPERTIES)};
    private final DockingWindow window;
    private final AbstractButton[][] buttons = new AbstractButton[WindowTabState.getStateCount()][];
    private final DirectionPanel[] buttonBoxes = new DirectionPanel[WindowTabState.getStateCount()];
    private final DirectionPanel customComponents = new DirectionPanel();
    private final DirectionPanel highlightedFocusedPanel = new DirectionPanel(){

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }
    };
    private final WindowTabProperties windowTabProperties = new WindowTabProperties(EMPTY_TAB_PROPERTIES);
    private ContainerList tabComponentsList;
    private boolean isFocused;
    private final PropertyMapListener windowPropertiesListener = new PropertyMapListener(){

        public void propertyValuesChanged(PropertyMap propertyMap, Map map) {
            WindowTab.this.updateTabButtons(null);
        }
    };
    private final PropertyMapTreeListener windowTabPropertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            WindowTab.this.updateTabButtons(map);
        }
    };

    WindowTab(DockingWindow dockingWindow, boolean bl) {
        super(dockingWindow.getTitle(), dockingWindow.getIcon(), bl ? null : new SimplePanel(dockingWindow), null);
        this.window = dockingWindow;
        for (int i = 0; i < WindowTabState.getStateCount(); ++i) {
            this.buttonBoxes[i] = new DirectionPanel(){

                public Dimension getMinimumSize() {
                    return new Dimension(0, 0);
                }
            };
            this.buttons[i] = new AbstractButton[buttonInfos.length];
        }
        this.highlightedFocusedPanel.add(this.customComponents);
        this.highlightedFocusedPanel.add(this.buttonBoxes[WindowTabState.HIGHLIGHTED.getValue()]);
        this.setHighlightedStateTitleComponent(this.highlightedFocusedPanel);
        this.setNormalStateTitleComponent(this.buttonBoxes[WindowTabState.NORMAL.getValue()]);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(mouseEvent);
                this.checkPopupMenu(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(mouseEvent);
                this.checkPopupMenu(mouseEvent);
            }

            private void checkPopupMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && WindowTab.this.contains(mouseEvent.getPoint())) {
                    WindowTab.this.window.showPopupMenu(mouseEvent);
                }
            }
        });
        this.getProperties().addSuperObject(this.windowTabProperties.getTitledTabProperties());
        PropertyMapWeakListenerManager.addWeakTreeListener(this.windowTabProperties.getMap(), this.windowTabPropertiesListener);
        PropertyMapWeakListenerManager.addWeakListener(this.window.getWindowProperties().getMap(), this.windowPropertiesListener);
        this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().addSuperObject(EMPTY_PROPERTIES);
    }

    public void updateUI() {
        super.updateUI();
        if (this.buttonBoxes != null) {
            for (int i = 0; i < WindowTabState.getStateCount(); ++i) {
                if (this.buttonBoxes[i] == null) continue;
                SwingUtilities.updateComponentTreeUI(this.buttonBoxes[i]);
            }
        }
    }

    void setFocused(boolean bl) {
        if (this.isFocused != bl) {
            this.isFocused = bl;
            TitledTabStateProperties titledTabStateProperties = bl ? this.windowTabProperties.getFocusedProperties() : EMPTY_PROPERTIES;
            this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().getMap().replaceSuperMap(this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().getMap().getSuperMap(), titledTabStateProperties.getMap());
            this.highlightedFocusedPanel.remove(1);
            this.highlightedFocusedPanel.add(this.buttonBoxes[bl ? WindowTabState.FOCUSED.getValue() : WindowTabState.HIGHLIGHTED.getValue()]);
            this.highlightedFocusedPanel.revalidate();
        }
    }

    void setProperties(WindowTabProperties windowTabProperties) {
        this.windowTabProperties.getMap().replaceSuperMap(this.windowTabProperties.getMap().getSuperMap(), windowTabProperties.getMap());
    }

    void unsetProperties() {
        this.setProperties(EMPTY_TAB_PROPERTIES);
    }

    void updateTabButtons(Map map) {
        WindowTabState[] windowTabStateArray = WindowTabState.getStates();
        for (int i = 0; i < windowTabStateArray.length; ++i) {
            WindowTabState windowTabState = windowTabStateArray[i];
            WindowTabStateProperties windowTabStateProperties = windowTabState == WindowTabState.FOCUSED ? this.windowTabProperties.getFocusedButtonProperties() : (windowTabState == WindowTabState.HIGHLIGHTED ? this.windowTabProperties.getHighlightedButtonProperties() : this.windowTabProperties.getNormalButtonProperties());
            InternalDockingUtil.updateButtons(buttonInfos, this.buttons[i], this.buttonBoxes[i], this.window, windowTabStateProperties.getMap(), map);
            this.buttonBoxes[i].setDirection((windowTabState == WindowTabState.NORMAL ? this.getProperties().getNormalProperties() : this.getProperties().getHighlightedProperties()).getDirection());
        }
        Direction direction = this.getProperties().getHighlightedProperties().getDirection();
        this.highlightedFocusedPanel.setDirection(direction);
        this.customComponents.setDirection(direction);
    }

    DockingWindow getWindow() {
        return this.window;
    }

    void windowTitleChanged() {
        this.setText(this.getWindow().getTitle());
        this.setIcon(this.getWindow().getIcon());
    }

    public String toString() {
        return this.window != null ? this.window.toString() : null;
    }

    void setContentComponent(Component component) {
        ((SimplePanel)this.getContentComponent()).setComponent(component);
    }

    List getCustomTabComponentsList() {
        if (this.tabComponentsList == null) {
            this.tabComponentsList = new ContainerList(this.customComponents);
        }
        return this.tabComponentsList;
    }
}

