/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.WindowItem;

class WindowDecoder {
    private WindowDecoder() {
    }

    static DockingWindow decodeWindow(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 1: {
                return View.read(objectInputStream, readContext);
            }
            case 2: {
                SplitWindow splitWindow = new SplitWindow(true);
                return splitWindow.oldRead(objectInputStream, readContext);
            }
            case 3: {
                TabWindow tabWindow = new TabWindow();
                return tabWindow.oldRead(objectInputStream, readContext);
            }
        }
        throw new IOException("Invalid window ID: " + n + '!');
    }

    static DockingWindow decodeWindow(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        int n = objectInputStream.readInt();
        if (n == 1) {
            return viewReader.readView(objectInputStream, readContext);
        }
        WindowItem windowItem = viewReader.readWindowItem(objectInputStream, readContext);
        switch (n) {
            case 2: {
                SplitWindowItem splitWindowItem = (SplitWindowItem)windowItem;
                if (splitWindowItem == null) {
                    splitWindowItem = new SplitWindowItem();
                    splitWindowItem.readSettings(objectInputStream, readContext);
                }
                SplitWindow splitWindow = new SplitWindow(splitWindowItem.isHorizontal(), splitWindowItem.getDividerLocation(), null, null, splitWindowItem);
                return splitWindow.newRead(objectInputStream, readContext, viewReader);
            }
            case 3: {
                TabWindowItem tabWindowItem = (TabWindowItem)windowItem;
                if (tabWindowItem == null) {
                    tabWindowItem = new TabWindowItem();
                    tabWindowItem.readSettings(objectInputStream, readContext);
                }
                TabWindow tabWindow = new TabWindow(null, tabWindowItem);
                return tabWindow.newRead(objectInputStream, readContext, viewReader);
            }
        }
        throw new IOException("Invalid window ID: " + n + '!');
    }
}

