% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{interaction_gen}
\alias{interaction_gen}
\title{Interaction Term Generation}
\usage{
interaction_gen(
  type = "lm",
  covariates = NULL,
  smooth = NULL,
  interaction = NULL,
  smooth_int_type = NULL
)
}
\arguments{
\item{type}{The type of model to be used for batch effect evaluation or harmonization (eg: "lmer", "lm", "gam").}

\item{covariates}{Name of covariates supplied to \code{model}.}

\item{smooth}{Variable names that require a smooth function.}

\item{interaction}{Expression of interaction terms supplied to \code{model} (eg: "age,diagnosis").}

\item{smooth_int_type}{A vector that indicates the types of interaction in \code{gam} models. By default, smooth_int_type is set to be NULL, "linear" represents linear interaction terms.
"categorical-continuous", "factor-smooth" both represent categorical-continuous interactions ("factor-smooth" includes categorical variable as part of the smooth),
"tensor" represents interactions with different scales, and "smooth-smooth" represents interaction between smoothed variables.}
}
\value{
\code{interaction_gen} returns a list containing the following components:
\item{interaction}{A vector of interaction terms to be included}
\item{covariates}{Modified covariates after expressing interaction terms}
\item{smooth}{Modified smooth terms after expressing interaction terms}
}
\description{
Generate appropriate interaction terms for regression models.
}
\examples{
interaction_gen(type = "lm", covariates = c("AGE", "SEX", "DIAGNOSIS"),
interaction = "AGE,DIAGNOSIS")

interaction_gen(type = "gam", covariates = c("AGE", "SEX", "DIAGNOSIS"),
smooth = "AGE", smooth_int_type = "linear", interaction = "AGE,DIAGNOSIS")

}
