% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_strConcat.R
\name{strVectorRepr}
\alias{strVectorRepr}
\title{String Representation of a character vector}
\usage{
strVectorRepr(ss, print_out = FALSE, single_quote = TRUE,
  start_with_c = TRUE)
}
\arguments{
\item{ss}{character.}

\item{print_out}{logical. Whether to print out the string representation.}

\item{single_quote}{Logical, whether to use single quote for wrap strings. Default to TRUE, when set to FALSE, double quote is used.}

\item{start_with_c}{Logical, whether the representation should start with "c(", when set to FALSE, "(" is used. Default to TRUE.}
}
\value{
character.
}
\description{
String Representation of a character vector
}
\examples{
\dontrun{
strVectorRepr(letters[1:3]) == 'c("a", "b", "c")'
strVectorRepr(
  as.character(1:3)) == 'c("1", "2", "3")'
all(eval(parse(text = strVectorRepr(as.character(1:3)))) == 
  c("1", "2", "3"))
}

}
\author{
Kaiyin Zhong, Fan Liu
}

