% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSequenceCohortSet.R
\name{generateSequenceCohortSet}
\alias{generateSequenceCohortSet}
\title{Intersecting the index and marker cohorts prior to calculating Sequence Symmetry Ratios}
\usage{
generateSequenceCohortSet(
  cdm,
  indexTable,
  markerTable,
  name,
  cohortDateRange = as.Date(c(NA, NA)),
  indexId = NULL,
  markerId = NULL,
  daysPriorObservation = 0,
  washoutWindow = 0,
  indexMarkerGap = NULL,
  combinationWindow = c(0, 365)
)
}
\arguments{
\item{cdm}{A CDM reference.}

\item{indexTable}{A table in the CDM that the index cohorts should come from.}

\item{markerTable}{A table in the CDM that the marker cohorts should come from.}

\item{name}{The name within the cdm that the output is called. Default is joined_cohorts.}

\item{cohortDateRange}{Two dates indicating study period and the sequences that the user wants
to restrict to.}

\item{indexId}{Cohort definition IDs in indexTable to be considered for the analysis.
Change to NULL if all indices are wished to be included.}

\item{markerId}{Cohort definition IDs in markerTable to be considered for the analysis.
Change to NULL if all markers are wished to be included.}

\item{daysPriorObservation}{The minimum amount of prior observation required on both the index
and marker cohorts per person.}

\item{washoutWindow}{A washout window to be applied on both the index cohort event and marker cohort.}

\item{indexMarkerGap}{The maximum allowable gap between the end of the first episode
and the start of the second episode in a sequence/combination.}

\item{combinationWindow}{A constrain to be placed on the gap between two initiations.
Default c(0,365), meaning the gap should be larger than 0 but less than or equal to 365.}
}
\value{
A table within the cdm reference.
}
\description{
Join two tables in the CDM (one for index and the other for marker cohorts)
into a new table in the cdm taking into account the maximum time interval between events.
Index and marker cohorts should be instantiated in advance by the user.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(
  cdm = cdm,
  name = "joined_cohorts",
  indexTable = "cohort_1",
  markerTable = "cohort_2"
)
 cdm$joined_cohorts
 CDMConnector::cdmDisconnect(cdm = cdm)
}
}
