% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Plot survival results}
\usage{
plotSurvival(
  result,
  x = "time",
  xscale = "days",
  ylim = c(0, NA),
  xlim = NULL,
  cumulativeFailure = FALSE,
  ribbon = TRUE,
  facet = NULL,
  colour = NULL,
  riskTable = FALSE,
  riskInterval = 30
)
}
\arguments{
\item{result}{Survival results}

\item{x}{Variable to plot on x axis}

\item{xscale}{X axis scale. Can be "days" or "years".}

\item{ylim}{Limits for the Y axis}

\item{xlim}{Limits for the X axis}

\item{cumulativeFailure}{whether to plot the cumulative failure probability
instead of the survival probability}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{riskTable}{Whether to print risk table below the plot}

\item{riskInterval}{Interval of time to print risk table below the plot}
}
\value{
A plot of survival probabilities over time
}
\description{
Plot survival results
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
plotSurvival(surv)
}

}
