% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkCohortSurvival.R
\name{benchmarkCohortSurvival}
\alias{benchmarkCohortSurvival}
\title{Estimate performance of estimateSurvival function for benchmarking}
\usage{
benchmarkCohortSurvival(
  cdm,
  targetSize,
  outcomeSize,
  outcomeDateVariable = "cohort_start_date",
  competingOutcomeSize = NULL,
  competingOutcomeDateVariable = "cohort_start_date",
  censorOnCohortExit = FALSE,
  censorOnDate = NULL,
  followUpDays = Inf,
  strata = NULL,
  eventGap = 30,
  estimateGap = 1,
  minCellCount = 5,
  returnParticipants = FALSE
)
}
\arguments{
\item{cdm}{CDM reference}

\item{targetSize}{number of people in the target cohort table}

\item{outcomeSize}{number of people in the outcome cohort table}

\item{outcomeDateVariable}{Variable containing date of outcome event}

\item{competingOutcomeSize}{number of people in the competing outcome cohort table}

\item{competingOutcomeDateVariable}{Variable containing date of
competing event}

\item{censorOnCohortExit}{If TRUE, an individual's follow up will be
censored at their cohort exit}

\item{censorOnDate}{if not NULL, an individual's follow up will be censored
at the given date}

\item{followUpDays}{Number of days to follow up individuals (lower bound 1,
upper bound Inf)}

\item{strata}{strata}

\item{eventGap}{Days between time points for which to report survival
estimates. First day will be day zero with risk estimates provided
for times up to the end of follow-up, with a gap in days equivalent
to eventGap.}

\item{estimateGap}{vector of time points at which to give survival estimates,
if NULL estimates at all times are calculated}

\item{minCellCount}{The minimum number of events to reported, below which
results will be obscured. If 0, all results will be reported.}

\item{returnParticipants}{Either TRUE or FALSE. If TRUE, references to
participants from the analysis will be returned allowing for further
analysis.}
}
\value{
tibble with performance of estimateSurvival function information,
according to the selected input parameters
}
\description{
Estimate performance of estimateSurvival function for benchmarking
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
cdm$condition_occurrence <- cdm$death_cohort \%>\%
dplyr::rename("condition_start_date" = "cohort_start_date",
             "condition_end_date" = "cohort_end_date") \%>\%
             dplyr::compute()
surv_timings <- benchmarkCohortSurvival(
cdm, targetSize = 100, outcomeSize = 20)
}

}
