% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{uniteNameLevel}
\alias{uniteNameLevel}
\title{Unite one or more columns in name-level format.}
\usage{
uniteNameLevel(
  x,
  cols,
  name = "group_name",
  level = "group_level",
  keep = FALSE
)
}
\arguments{
\item{x}{Tibble or data.frame.}

\item{cols}{Columns to aggregate.}

\item{name}{Column name of the \code{name} column.}

\item{level}{Column name of the \code{level} column.}

\item{keep}{Whether to keep the original columns.}
}
\value{
A Tibble with the new columns.
}
\description{
Unite one or more columns in name-level format.
}
\examples{
\donttest{
x <- dplyr::tibble(
  variable = "number subjects",
  value = c(10, 15, 40, 78),
  sex = c("Male", "Female", "Male", "Female"),
  age_group = c("<40", ">40", ">40", "<40")
)

x

x |>
  CohortSurvival:::uniteNameLevel(
    cols = c("sex", "age_group"),
    name = "new_column_name",
    level = "new_column_level"
  )
}


}
