% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDeathCohort.R
\name{generateDeathCohortSet}
\alias{generateDeathCohortSet}
\title{To create a death cohort}
\usage{
generateDeathCohortSet(
  cdm,
  name,
  deathInObservation = FALSE,
  cohortTable = NULL,
  cohortId = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{cdm}{CDM reference}

\item{name}{name for the created death cohort table}

\item{deathInObservation}{If TRUE, restricts deaths included to only those
observed during an ongoing observation period.}

\item{cohortTable}{name of the cohort table to create a death cohort for}

\item{cohortId}{name of the cohort table to create a death cohort for}

\item{overwrite}{Should the cohort table be overwritten if it already exists?}
}
\value{
A cohort table with a death cohort in cdm
}
\description{
To create a death cohort
}
\examples{
\donttest{
library(CDMConnector)
library(CohortSurvival)
cdm <- PatientProfiles::mockPatientProfiles()
deathTable <- dplyr::tibble(
  person_id = c(1,2,3),
  death_date = c(as.Date("2020-01-01"),
                 as.Date("2020-01-02"),
                 as.Date("2020-01-01")))
DBI::dbWithTransaction(attr(cdm, "dbcon"), {
  DBI::dbWriteTable(attr(cdm, "dbcon"), "death",
                    deathTable, overwrite = TRUE)
})
cdm$death <- dplyr::tbl(attr(cdm, "dbcon"), "death")
cdm <- generateDeathCohortSet(cdm=cdm,
                              name = "death_cohort")
}
}
