% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exitAtDate.R
\name{exitAtObservationEnd}
\alias{exitAtObservationEnd}
\title{Set cohort end date to end of observation}
\usage{
exitAtObservationEnd(cohort, cohortId = NULL, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{name}{Name of the new cohort with the restriction.}
}
\value{
The cohort table.
}
\description{
This functions changes cohort end date to the end date of the observation
period corresponding to the cohort entry. In the case were this generates
overlapping records in the cohort, overlapping entries will be merged.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor()
cdm$cohort1 |> exitAtObservationEnd()
}
}
