% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaOptimizeInit.R
\name{ctmaOptimzeInit}
\alias{ctmaOptimzeInit}
\title{ctmaOptimzeInit}
\usage{
ctmaOptimzeInit(
  oldStudyList = NULL,
  activeDirectory = NULL,
  problemStudy = NULL,
  reFits = NULL,
  n.latent = NULL,
  coresToUse = c(1),
  activateRPB = FALSE,
  checkSingleStudyResults = FALSE
)
}
\arguments{
\item{oldStudyList}{oldStudyList}

\item{activeDirectory}{activeDirectory}

\item{problemStudy}{problemStudy}

\item{reFits}{reFits}

\item{n.latent}{n.latent}

\item{coresToUse}{If neg., the value is subtracted from available cores, else value = cores to use}

\item{activateRPB}{set to TRUE to receive push messages with 'CoTiMA' notifications on your phone}

\item{checkSingleStudyResults}{Displays estimates from single study 'ctsem' models and waits for user input to continue.
Useful to check estimates before they are saved.}
}
\value{
returns a list with bestFit (= the best fit achieved), all_minus2ll (= all -2ll values for all fitted models), and summary, which
is printed if the summary function is applied to the returned object, and which shows the summary information of the ctsem model with the
best fit.
}
\description{
Initial fitting (i.e., applies \code{\link{ctmaInit}}) to a primary study reFit times to capitalize on chance for obtaining
a hard-to-find optimal fit. This could be very helpful if a primary yields out-of-range estimates, which could happen if the fitting
algorithm unfortunately used random start values that resulted in a locally but not globally optimal fit. Essentially, using
ctmaOptimzeInit is like gambling, hoping that at leas one set of starting values (the number is tries is specified in the reFits argument)
eneables finding the global optimal fit. On unix-like machines (e.g. MacOS), this could be done in parallel mode if coresToUse > 1.
}
\note{
All but one of multiple cores are used on unix-type machines for parallel fitting

During fitting, not output is generated. Be patient.
}
\examples{
\dontrun{
optimFit313 <- ctmaOptimzeInit(oldStudyList=CoTiMAstudyList_3,
                               activeDirectory="/Users/tmp/",  # adapt!
                               problemStudy=which(CoTiMAstudyList_3$studyNumbers == 313),
                               reFits=10,
                               n.latent=2)
summary(optimFit313)
}

}
