% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{betaplot}
\alias{betaplot}
\title{\eqn{\beta(x)} plot}
\usage{
betaplot(x, fit, x.grid = NULL, xlim = c(0, max(x)), xlab = "x")
}
\arguments{
\item{x}{numeric vector for the covariate relative to the dose of exposure used in \code{comire.gibbs}.}

\item{fit}{the output of \code{comire.gibbs} opportunely trasformed in \code{classCoMiRe} class.}

\item{x.grid}{optional numerical vector giving the actual values of the grid for x for plotting \eqn{\beta(x)}. 
If \code{x.gird} is not provided, standard grids are automatically used.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates ranges for the plot.}

\item{xlab}{the title of the x axis.}
}
\description{
Posterior mean (continuous lines) and pointwise credible bands (shaded areas) for \eqn{\beta(x)}.
}
\examples{
{
data(CPP)
attach(CPP)

n <- NROW(CPP)
J <- H <- 10

premature <- as.numeric(gestage<=37)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## too few iterations to be meaningful. see below for safer and more comprehensive results

mcmc <- list(nrep=10, nb=2, thin=1, ndisplay=4) 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit.dummy <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=1, max.x=180)
                     
betaplot(x=dde, fit=fit.dummy, x.grid=seq(0,180, length=100), xlim=c(0,150))

\donttest{
## safer procedure with more iterations (it may take some time)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## Fit the model for continuous y 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit1 <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=5, max.x=180)

                         
betaplot(x=dde, fit=fit1, x.grid=seq(0,180, length=100), xlim=c(0,150))

}
}
}
\author{
Antonio Canale
}
