% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudyingParam.R
\name{StudyingParam}
\alias{StudyingParam}
\title{Controlling quality of the convergence in BPBM}
\usage{
StudyingParam(Sum, MCMC.CHAINS)
}
\arguments{
\item{Sum}{Matrix with the summary of the "Estimating_BPBM".It is the output of the "Estimating_BPBM" adding "$R2jagsOutput$BUGSoutput$summary".}

\item{MCMC.CHAINS}{Matrix with the values of all the Markov chains for all parameters. It is the output of the "Estimating_BPBM" adding "$SamplesAllChains".}
}
\value{
Returns a list with:
\itemize{
  \item Param.Summary:  Matrix. The matrix Sum with a zero in the column \code{Sum[,"mean"]} when a parameter has the zero in the center of its credible interval.
   \item AllChainsJoined:  Matrix. The matrix MCMC.CHAINS with a zero in all the iterations of the chain when a parameter has the zero in the center of its credible interval.
  }
}
\description{
This function controls that the value of the Rhat is between 0.9 and 1.1. In addition, it controls that the effective sample size is bigger than 100 and that the zero is not at the center of the credible interval (the interval between 2.5 and 97.5). We consider that the zero is in the center of the credible interval when the zero is between the 25 and the 75 quantile of the distribution formed by the limits if the credible interval.
}
\examples{

set.seed(314)
especie=t(gtools::rdirichlet(n=6, c(6,6,1,6,6)))
E=5
Tt=6
MatrizPBmodelo=rbind(c(1,1,1,1,1,1),c(-0.3,0.4,0.3,-0.7,-0.4,-0.6),c(0.3,0.5,-0.3,0.1,0.4,0.1))

est=Estimating_BPBM(especie,
                   Tt,
                   E,
                   MatrizPBmodelo,
                   nn.chain=3,
                   nn.burnin=1000,
                   nn.sample=5000,
                   nn.thin=10)

StudyingParam(est$R2jagsOutput$BUGSoutput$summary,est$SamplesAllChains)


}
