% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAbiplot.R
\name{PCAbiplot}
\alias{PCAbiplot}
\title{PCA of the estimated parameters}
\usage{
PCAbiplot(paramEstimadosFinal, names, E)
}
\arguments{
\item{paramEstimadosFinal}{The estimate parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial especies present in the matrix \code{especie}.}

\item{names}{Vector with the name of the bacteria. The component i has the name of the bacteria i, with i=1,...,D. The bacteria in the las position of the vector is the bacteria used as reference in the alr transformation.}

\item{E}{Number of bacteria available.}
}
\value{
Returns a list with the PCA biplot, the variance explained of each Principal Component and an object of class "prcomp" with the PCA. In the biplot, "a" denotes the intercept, "b" denotes the parameter that give information about the importance of the bacteria in defining herself in  the next time point and "c" denotes denotes the parameter that give information about the importance of the rest of the community in defining the bacteria in  the next time point.
}
\description{
This function applys a PCA to the estimate parameters (using function "prcomp" with \code{center = TRUE} and \code{scale. = TRUE}). Then uses the ggbiplot function to plot the biplot.
}
\examples{

set.seed(123)
especie=t(gtools::rdirichlet(10,c(1,3,1,2,4)))
names=c("Bact1","Bact2","Bact3","Bact4","Bact5")
tau1=0.4
parms1= cbind(c(0.1,0.2,0.4,0.6),c(-0.2,0.1,0.1,0.3),c(0.3,0.2,0.3,0.5))
paramEstimadosFinal=c(as.vector( t(parms1)),tau1)

PCAbiplot(paramEstimadosFinal,names,5)

}
