#' @export print.clustab
#' @export
#' @name print.clustab
#' @title Print a 'clustab' object
#' @description This is a method for the function print for objects of the class \code{clustab}.
#' @param x An object of class \code{clustab} generated by the function \code{\link{stability}}.
#' @param \dots Further arguments to be passed to or from other methods. They are ignored in this function.
#' @keywords internal
#' 
print.clustab <- function(x, ...){
  if (!inherits(x, "clustab")) 
    stop("use only with \"clustab\" objects")
  cat("\nCall:\n", deparse(x$call), "\n\n", sep = "")
  cat("\n")
  res <- matrix("",2,2)
  colnames(res) <-c("name","description")
  res[1,] <- c("$matCR", "matrix of corrected Rand indices")
  res[2,] <- c("$meanR", "vector of mean corrected Rand indices")
  row.names(res) <- rep("",2) 
  print(res)
}

