% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{backward.explorer}
\alias{backward.explorer}

\title{Gather a set of the most competitive models.}

\description{
This function gathers a set of the most competitive models using a backward-stepwise strategy. The visited models are gathered in a file with suffix "_ExploredModels.txt". The algorithm used is described in 
\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)}.
}

\usage{
backward.explorer(x, Kmax, Criterion, ploidy = 1,
  ForceExclusion = FALSE, emOptions = list(epsi = NULL, nberSmallEM = NULL,
  nberIterations = NULL, nberMaxIterations = NULL, typeSmallEM = NULL, typeEM =
  NULL, putThreshold = NULL), Kmin = 1, Smin = NULL,
  project = deparse(substitute(x)))
}
\arguments{
\item{x}{A matrix of string that contains data.}

\item{Kmax}{The maximum number of clusters to be explored.}

\item{Criterion}{The model selection criterion in c("BIC", "AIC", "ICL", "CteDim") used for exploration (see details).}

\item{ploidy}{The number of columns for each variable in the data. For example, \eqn{ploidy = 2} for genotypic data from diploid individual.}

\item{ForceExclusion}{The indication of whether to force exclusion or not. The default value is set to FALSE.}

\item{emOptions}{A list of EM options (see \code{\link{EmOptions}} and \code{\link{setEmOptions}}).}

\item{Kmin}{The minimum number of clusters. The default value is set to 1.}

\item{Smin}{A logical vector that indicates the variables to include in the selected set of clustering variables.
The default value NULL: no variable is preselected.}

\item{project}{The name of the project. The default value is the name of the dataset.}
}
\value{
A data.frame of selected models for the choosen proposed criteria.
}

\details{
	If the penalized criteria is \code{CteDim}, a sequence of penalty functions of the form
	\eqn{pen\left(K,S\right)=\lambda*dim\left(K,S\right)} is used. In this shape of penalty function, 
	\eqn{\lambda} is in \eqn{[0.5, log(N)]}, where \eqn{N} is the number of individuals in the sample 
	data. Thus, \code{AIC} and \code{BIC} penalties are in the sequence of candidate penalties.
}
\examples{
data(genotype1)
head(genotype1) 
genotype2 = cutEachCol(genotype1[, -11], ploidy = 2)
head(genotype2)

# The following command create a file "genotype2_ExploredModels.txt" 
# that contains the most competitive models.

#output = backward.explorer(genotype2, Kmax = 10, ploidy = 2, Kmin = 1, Criterion = "CteDim")

data(genotype2_ExploredModels)
head(genotype2_ExploredModels)
}
\author{
Wilson Toussile
}
\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and 	variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{dimJump.R}} for the data driven calibration of the penalty function, and
	\code{\link{model.selection.R}} for the final model selection.
}
\keyword{Backward-stepwise selection}
\keyword{Variable selection in Clustering}
\keyword{EM}

