% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{clusboot}
\alias{clusboot}
\title{Performs bootstrap on a cluster analysis output}
\usage{
clusboot(datmat, B = 1000, clustering.func = complete.linkage, ...)
}
\arguments{
\item{datmat}{a data matrix or distance object which will be the input to the clustering function}

\item{B}{number of bootstrap replicates}

\item{clustering.func}{the function which will perform the clustering and output a vector of cluster memberships}

\item{...}{more arguments to be passed to the clustering function}
}
\value{
an object of class \code{clusboot} which is a list with the following components:
\item{proportions}{matrix of size nxn with cell ij containing the proportion of bootstrap replicates
in which object i and object j clustered together.}
\item{clustering}{a vector of length n containing the cluster membership of the n input objects.}
\item{sil}{a vector of length the number of clusters containing the bootstrap-silhouette values for the clusters.}
\item{indv.sil}{a vector of length n containing the bootstrap-silhouette values for the individual objects.}
\item{sil.order}{a vector of length n containing the ordering of the n objects used by the functions
\code{boot.silhouette} and \code{boot.proportions} to order objects in the same cluster adjacent and
clusters in decreasing order of cluster tightness.}
\item{ave.sil.width}{the overall stability of the clustering solution, obtained by averaging over the individual object bootstrap-silhouette values.}
}
\description{
Performs bootstrap on a cluster analysis output
}
\details{
Any R function performing cluster analysis can be specified in \code{clustering.func} although a wrapper function is
typically needed to isolate only the vector output of cluster memberships. See \code{?complete.linkage} as an example.
Should users perfer to use alternative resamling schemes, other than the bootstrap, Hennig (2007) discuss a variety
of options which could be accessed by specifying \code{clustering.func = fpc.clusterboot}. In addition, the sampling
method is specified in the argument \code{bootmethod} and additional arguments for the function \code{clusterboot} in the
package \code{fpc} must be given. Note that only the resampling facilities of \code{clusterboot} is utilised while the
computation of proportions and silhouette widths remain unchanged. The output object of class \code{clusboot}
will remain unchanged as only the resampling section of \code{clusterboot} is used.
}
\examples{
clusboot (scale(case.study.psychiatrist), B=100, k=6, clustering.func=complete.linkage)
library(fpc)
clusboot (scale(case.study.psychiatrist), B=100, k=6, clustering.func=fpc.clusterboot,
          clustermethod=hclustCBI, method="complete", bootmethod="subset", subtuning=10)

}
\references{
Hennig, C., 2007. Cluster-wise assessment of cluster stability. Computational Statistics & Data Analysis,
52(1), pp.258-271.
}
