% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_tree_edges.R
\name{match_tree_edges}
\alias{match_tree_edges}
\title{Edge matching function}
\usage{
match_tree_edges(original_tree, pruned_tree)
}
\arguments{
\item{original_tree}{A tree in phylo format.}

\item{pruned_tree}{A tree in phylo format that represents a pruned version of \code{original_tree}.}
}
\value{
\item{matching_edges}{A list of the matching edges.}
\item{matching_nodes}{A matrix of matching node numbers.}
\item{removed_edges}{A vector of the removed edges.}
}
\description{
Given two trees where one is a pruned version of the other gives matching edges and nodes of pruned tree to original tree.
}
\details{
Finds matching edge(s) and node(s) for a pruned tree in the original tree from which it was created. This is intended as an internal function, but may be of use to someone.
}
\examples{

# Create a random 10-taxon tree:
original_tree <- ape::rtree(n = 10)

# Remove three leaves:
pruned_tree <- ape::drop.tip(phy = original_tree, tip = c("t1", "t3", "t8"))

# Find matching edges:
X <- match_tree_edges(original_tree, pruned_tree)

# Show matching edges:
X$matching_edges

# Show matching nodes:
X$matching_nodes

# Show removed edges:
X$removed_edges
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
