% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteMorphTNT.R
\name{WriteMorphTNT}
\alias{WriteMorphTNT}
\title{Writes out a morphological TNT data file}
\usage{
WriteMorphTNT(CladisticMatrix, filename, add.analysis.block = FALSE)
}
\arguments{
\item{CladisticMatrix}{The cladistic matrix in the format imported by \link{ReadMorphNexus}.}

\item{filename}{The file name to write to. Should end in \code{.tnt}.}

\item{add.analysis.block}{Whether or not to add analysis block (i.e., tree search commands).}
}
\description{
Writes out a morphological data file in Hennig86/TNT format.
}
\details{
Writes out a TNT (Goloboff et al. 2008) data file representing the distribution of discrete morphological characters in a set of taxa. Data must be in the format created by importing data with \link{ReadMorphNexus}.
}
\examples{

# Write out Michaux 1989 to current working directory:
WriteMorphTNT(CladisticMatrix = Michaux1989, filename = "Michaux1989.tnt")

# Remove file when finished:
file.remove("Michaux1989.tnt")

}
\references{
Goloboff, P., Farris, J. and Nixon, K., 2008. TNT, a free program for phylogenetic analysis. Cladistics, 24, 774-786.
}
\seealso{
\link{WriteMorphNexus}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
