% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_position.R
\name{adj_position}
\alias{adj_position}
\title{Adjust Marker Positions Towards Center}
\usage{
adj_position(data, distance = 1)
}
\arguments{
\item{data}{A data frame where each row represents a marker at a specific timeframe, with columns 'Timeframe', 'Marker', 'X', 'Y', 'Z'.}

\item{distance}{Numeric value indicating the distance to adjust towards the center (default is 1 cm).}
}
\value{
A data frame of the same dimensions as \code{data}, containing the adjusted marker coordinates.
}
\description{
Adjusts the positions of markers by moving them towards the average center position within each timeframe
by a specified distance. This accounts for marker protrusion from the skin surface.
}
\details{
The function calculates the average center position of all markers within each timeframe and moves each marker towards the center
by the specified distance along the line connecting the marker to the center.
}
\examples{
data("sample_data")
processed_data <- process_marker_data(head(sample_data))
adjusted_data <- adj_position(processed_data, distance = 1)
head(adjusted_data)

}
