% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removePeaks2D.R
\name{removePeaks2D}
\alias{removePeaks2D}
\title{Remove Peaks in a Spectra2D Object}
\usage{
removePeaks2D(spectra, remF2 = NULL, remF1 = NULL)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}} from which to
remove selected peaks.}

\item{remF2}{A formula giving the range of frequencies to be set to \code{NA}.  May include
"low" or "high" representing the extremes of the spectra.    Values outside the range of
F2 are tolerated without notice and are handled \code{min} or \code{max}.See the examples.}

\item{remF1}{As for \code{remF2}.}
}
\value{
An object of S3 class \code{\link{Spectra2D}}.
}
\description{
This function sets peaks at specified frequencies in a \code{\link{Spectra2D}}
object to \code{NA}. This effectively removes these peaks from calculations of
contours which can speed things up and clarifies the visual presentation of data.
This function is useful for removing regions with large
interfering peaks (e.g. the water peak in 1H NMR), or regions that are primarily
noise.  This function leaves the frequency axes intact.  Note that the
\code{\link[multiway]{parafac}} function does not allow \code{NA}
in the input data matrices.  See \code{\link{removeFreq}} for a way to shrink
the data set without introducing \code{NA}s.
}
\examples{
# Note we will set contours a bit low to better
# show what is going on.

data(MUD1)
mylvls <- seq(-0.3, 0.3, 0.1)
mylvls[4] <- 0.05

plotSpectra2D(MUD1, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7: Complete Data Set")

MUD1a <- removePeaks2D(MUD1, remF2 = 2.5 ~ 4)
sumSpectra(MUD1a)
plotSpectra2D(MUD1a, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7\\nRemoved Peaks: F2 2.5 ~ 4")

MUD1b <- removePeaks2D(MUD1, remF2 = low ~ 5)
sumSpectra(MUD1b)
plotSpectra2D(MUD1b, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7\\nRemoved Peaks: F2 low ~ 5")

MUD1c <- removePeaks2D(MUD1, remF1 = high ~ 23)
sumSpectra(MUD1c)
plotSpectra2D(MUD1c, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7\\nRemoved Peaks: F1 high ~ 23")

MUD1d <- removePeaks2D(MUD1, remF2 = 2.5 ~ 4, remF1 = 17 ~ 20)
sumSpectra(MUD1d)
plotSpectra2D(MUD1d, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7\\nRemoved Peaks: F2 2.5 ~ 4 & F1 17 ~ 20")

}
\seealso{
\code{\link[ChemoSpecUtils]{removeFreq}}.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{utilities}
