% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgfSpectra.R
\name{sgfSpectra}
\alias{sgfSpectra}
\title{Apply Savitzky-Golay filters to a Spectra object}
\usage{
sgfSpectra(spectra, m = 0, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{m}{The desired m-th derivative.  \code{m = 0} smooths the data (i.ei a rolling
average), \code{m = 1} gives the first derivative etc.}

\item{\dots}{Other parameters to be passed to
\code{\link[signal]{sgolayfilt}}.}
}
\value{
A object of class \code{\link{Spectra}}.
}
\description{
This function is a simple wrapper around the function
\code{\link[signal]{sgolayfilt}}.  It allows one to apply Savitzky-Golay
filters to a \code{\link{Spectra}} object in a convenient way.
}
\examples{
# You need to install package "signal" for this example
# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
if (requireNamespace("signal", quietly = TRUE)) {
  library("ggplot2")
  library("patchwork")
  data(SrE.IR)
  myt1 <- expression(bolditalic(Serenoa) ~ bolditalic(repens) ~ bold(IR ~ Spectra))
  myt2 <- expression(bolditalic(Serenoa) ~ bolditalic(repens) ~ bold(IR ~ Spectra ~ (Smoothed)))

  p1 <- plotSpectra(SrE.IR)
  p1 <- p1 + ggtitle(myt1) + coord_cartesian(xlim = c(1900, 2100), ylim = c(0.0, 0.03))

  sgf <- sgfSpectra(SrE.IR)

  p2 <- plotSpectra(sgf)
  p2 <- p2 + ggtitle(myt2) + coord_cartesian(xlim = c(1900, 2100), ylim = c(0.0, 0.03))

  p3 <- p1/p2
  p3
}

}
\seealso{
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{multivariate}
\keyword{utilities}
