% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3dScores.R
\name{plot3dScores}
\alias{plot3dScores}
\title{3D PCA Score Plot for a Spectra Object}
\usage{
plot3dScores(
  spectra,
  pca,
  pcs = c(1:3),
  ellipse = TRUE,
  rob = FALSE,
  cl = 0.95,
  frac.pts.used = 0.8
)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{pca}{An object of class \code{\link{prcomp}}.}

\item{pcs}{A vector of three integers specifying the PCA scores to plot.}

\item{ellipse}{Logical indicating if confidence ellipses should be drawn.}

\item{rob}{Logical; if \code{ellipse = TRUE}, indicates that robust
confidence ellipses should be drawn.  If \code{FALSE}, classical confidence
ellipses are drawn.}

\item{cl}{A number indicating the confidence interval for the ellipse.}

\item{frac.pts.used}{If \code{ellipse = TRUE} and \code{rob = TRUE}, a
number indicating the fraction of the data points to be considered "good"
and thus used to compute the robust confidence ellipse.}
}
\value{
None.  Side effect is a plot in a browser window.
}
\description{
Creates an interactive 3D plot of PCA scores from the analysis of a
\code{\link{Spectra}} object, color coded according the to scheme stored in
the object.  The plot is created by \code{plotly} and appears in a browser window.
}
\examples{
if (interactive()) {
  data(metMUD1)
  pca <- c_pcaSpectra(metMUD1, choice = "noscale")
  p <- plot3dScores(metMUD1, pca)
  p
}

}
\seealso{
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University)
}
\keyword{hplot}
\keyword{multivariate}
