% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpectraJS.R
\name{plotSpectraJS}
\alias{plotSpectraJS}
\title{Plot a Spectra Object Interactively}
\usage{
plotSpectraJS(spectra, which = NULL, browser = NULL, minify = TRUE)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}} to be checked.}

\item{which}{Integer.  If not \code{NULL}, specifies by number which spectra to plot.
If greater control is needed, use \code{\link{removeSample}} which is more flexible
before calling this function.}

\item{browser}{Character.  Something that will make sense to your OS.  Only
necessary if you want to override your system specified browser as
understood by \code{R}.  See below for further details.}

\item{minify}{Logical.  Shall the JavaScript be minified?  This improves
performance.  However, it requires package \code{js} which in turn requires
package \code{V8}.  The latter is not available on all platforms.  Details
may be available at \url{https://github.com/jeroenooms/v8}}
}
\value{
None; side effect is an interactive web page.  The temporary
directory containing the files that drive the web page is written to the
console in case you wish to use those files.  This directory is deleted when
you quit R.  If you wish to read the file, don't minify the code, it will be
unreadable.
}
\description{
This function uses the d3.js JavaScript library by Mike Bostock to plot a \code{\link{Spectra}}
object interactively.  This is most useful for data exploration.  For high
quality plots, consider \code{\link{plotSpectra}}.
}
\details{
The spectral data are incorporated into the web page. Keep in mind that very large
data sets, like NMR spectra with 32K points, will bog down the browser.
In these cases, you may need to limit the number of samples in passed to this function.
See \code{\link{removeSample}} or use argument \code{which}.
}
\section{Browser Choice}{
 The browser is called by
\code{\link[utils]{browseURL}}, which
in turn uses \code{options("browser")}.  Exactly how this is handled
is OS dependent.
}

\section{RStudio Viewer}{
 If browser is \code{NULL}, you are using RStudio, and a viewer is specified, this will be called.  You can stop this by with \code{options(viewer = NULL)}.
}

\section{Browser Choice (Mac)}{
 On a Mac, the default browser is called
by \code{/bin/sh/open}
which in turn looks at which browser you have set in the system settings.  You can
override your default with
\code{browser = "/usr/bin/open -a 'Google Chrome'"} for example.
}

\section{Browser Choice & Performance}{
  You can check the performance of
your browser at peacekeeper.futuremark.com  The most relevant score
is the rendering category.
}

\examples{

if (interactive()) {
  require("jsonlite")
  require("js")
  data(metMUD2)
  plotSpectraJS(metMUD2)
}

}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\seealso{
\code{\link{plotSpectra}} for non-interactive plotting.  Details
about \code{d3.js} are at \url{www.d3js.org}.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{plot}
