% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspection}
\alias{inspection}
\alias{inspect}
\alias{grab}
\title{Helpers for inspecting causal models}
\usage{
inspect(model, what = NULL, ...)

grab(model, what = NULL, ...)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{what}{A character string specifying the component to retrieve.
Available options are:
\itemize{
\item "\code{statement}" a character string describing causal relations using dagitty syntax,
\item "\code{nodes}" A list containing the nodes in the model,
\item "\code{parents_df}" A table listing nodes, whether they are root nodes or not, and the number and names of parents they have,
\item "\code{parameters}" A vector of 'true' parameters,
\item "\code{parameter_names}" A vector of names of parameters,
\item "\code{parameter_mapping}" A matrix mapping from parameters into data types,
\item "\code{parameter_matrix}" A matrix mapping from parameters into causal types,
\item "\code{parameters_df}" A data frame containing parameter information,
\item "\code{causal_types}" A data frame listing causal types and the nodal types that produce them,
\item "\code{nodal_types}" A list with the nodal types of the model,
\item "\code{data_types}" A list with all data types consistent with the model; for options see \code{?get_all_data_types},
\item "\code{ambiguities_matrix}" A matrix mapping from causal types into data types,
\item "\code{type_prior}" A matrix of type probabilities using priors,
\item "\code{prior_hyperparameters}" A vector of alpha values used to parameterize Dirichlet prior distributions; optionally provide node names to reduce output, e.g., \code{inspect(prior_hyperparameters, nodes = c('M', 'Y'))},
\item "\code{prior_event_probabilities}" A vector of data (event) probabilities given a single realization of parameters; for options see \code{?get_event_probabilities},
\item "\code{prior_distribution}" A data frame of the parameter prior distribution,
\item "\code{posterior_distribution}" A data frame of the parameter posterior distribution,
\item "\code{posterior_event_probabilities}" A sample of data (event) probabilities from the posterior,
\item "\code{type_distribution}" A matrix of type probabilities using posteriors,
\item "\code{data}" A data frame with data that was provided to update the model,
\item "\code{stanfit}" A \code{stanfit} object generated by Stan; prints \code{stanfit} summary with updated parameter names,
\item "\code{stan_warnings}" Messages generated during the generation of a \code{stanfit}object.
\item "\code{stan_summary}" A list of Stan outputs that includes \code{stanfit}, \code{data}, and, if requested when updating the model, posterior \code{event_probabilities} and \code{type_distribution}; prints \code{stanfit} summary with updated parameter names.
}}

\item{...}{Other arguments passed to helper \code{"get_*"} functions: get_all_data_types, get_event_probabilities,  get_priors, Anys such additional arguments must be named.}
}
\value{
Objects  that can be derived from a \code{causal_model}, with summary.

Quiet return of objects that can be derived from a \code{causal_model}.
}
\description{
Various helpers to inspect or access internal objects generated or used by Causal Models

Returns specified elements from a \code{causal_model} and prints summary.
Users can use \code{inspect} to extract model's components or objects implied by
the model structure including nodal types, causal types, parameter priors,
parameter posteriors, type priors, type posteriors, and other relevant elements.
See argument \code{what} for other options.

Returns specified elements from a \code{causal_model}.
Users can use \code{inspect} to extract model's components or objects implied by
the model structure including nodal types, causal types, parameter priors,
parameter posteriors, type priors, type posteriors, and other relevant elements.
See argument \code{what} for other options.
}
\examples{
\donttest{

model <- make_model("X -> Y")
data <- make_data(model, n = 4)

inspect(model, what = "statement")
inspect(model, what = "parameters")
inspect(model, what = "nodes")
inspect(model, what = "parents_df")
inspect(model, what = "parameters_df")
inspect(model, what = "causal_types")
inspect(model, what = "prior_distribution")
inspect(model, what = "prior_hyperparameters", nodes = "Y")
inspect(model, what = "prior_event_probabilities", parameters = c(.1, .9, .25, .25, 0, .5))
inspect(model, what = "prior_event_probabilities", given = "Y==1")
inspect(model, what = "data_types", complete_data = TRUE)
inspect(model, what = "data_types", complete_data = FALSE)


model <- update_model(model,
  data = data,
  keep_fit = TRUE,
  keep_event_probabilities = TRUE)

inspect(model, what = "posterior_distribution")
inspect(model, what = "posterior_event_probabilities")
inspect(model, what = "type_distribution")
inspect(model, what = "data")
inspect(model, what = "stan_warnings")
inspect(model, what = "stanfit")
}

model <- make_model("X -> Y")

x <- grab(model, what = "statement")
x
}
