% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{get_all_data_types}
\alias{get_all_data_types}
\title{Get all data types}
\usage{
get_all_data_types(
  model,
  complete_data = FALSE,
  possible_data = FALSE,
  given = NULL
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{complete_data}{Logical. If `TRUE` returns only complete data types
(no NAs). Defaults to `FALSE`.}

\item{possible_data}{Logical. If `TRUE` returns only complete data types
(no NAs) that are *possible* given model restrictions. Note that in
principle an intervention could make observationally impossible data types
arise. Defaults to `FALSE`.}

\item{given}{A character.  A quoted statement that evaluates to logical.
Data conditional on specific values.}
}
\value{
A \code{data.frame} with all data types (including NA types)
  that are possible from a model.
}
\description{
Creates dataframe with all data types (including NA types)
that are possible from a model.
}
\examples{
\donttest{
make_model('X -> Y') |> get_all_data_types()
model <- make_model('X -> Y') \%>\%
  set_restrictions(labels = list(Y = '00'), keep = TRUE)
  get_all_data_types(model)
  get_all_data_types(model, complete_data = TRUE)
  get_all_data_types(model, possible_data = TRUE)
  get_all_data_types(model, given  = 'X==1')
  get_all_data_types(model, given  = 'X==1 & Y==1')
}
}
