% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{collapse_data}
\alias{collapse_data}
\title{Make compact data with data strategies}
\usage{
collapse_data(
  data,
  model,
  drop_NA = TRUE,
  drop_family = FALSE,
  summary = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame}.  Data of nodes that can take three values: 0, 1, and NA. In long form as generated by \code{\link{make_events}}}

\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{drop_NA}{Logical. Whether to exclude strategy families that contain no observed data. Exceptionally if no data is provided, minimal data on data on first node is returned. Defaults to `TRUE`}

\item{drop_family}{Logical. Whether to remove column \code{strategy} from the output. Defaults to `FALSE`.}

\item{summary}{Logical. Whether to return summary of the data. See details.  Defaults to `FALSE`.}
}
\value{
A vector of data events

If \code{summary = TRUE} `collapse_data` returns a list containing the following components:
\item{data_events}{A compact data.frame of event types and strategies.}
   \item{observed_events}{A vector of character strings specifying the events observed in the data}
   \item{unobserved_events}{A vector of character strings specifying the events not observed in the data}
}
\description{
Take a `data.frame` and return compact `data.frame`  of event types and strategies.
}
\examples{
\donttest{

model <- make_model('X -> Y')

df <- data.frame(X = c(0,1,NA), Y = c(0,0,1))

df \%>\% collapse_data(model)


collapse_data(df, model, drop_NA = FALSE)

collapse_data(df, model, drop_family = TRUE)

collapse_data(df, model, summary = TRUE)

data <- make_data(model, n = 0)
collapse_data(data, model)

model <- make_model('X -> Y') \%>\% set_restrictions('X[]==1')
df <- make_data(model, n = 10)
df[1,1] <- ''
collapse_data(df, model)
data <- data.frame(X= 0:1)
collapse_data(data, model)

}

}
