% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_model.R
\name{query_model}
\alias{query_model}
\title{Generate estimands dataframe}
\usage{
query_model(
  model,
  queries = NULL,
  given = NULL,
  using = list("priors"),
  parameters = NULL,
  stats = NULL,
  digits = 3,
  n_draws = 4000,
  expand_grid = FALSE,
  query = NULL
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{queries}{A vector of characters. Query on potential outcomes such as "Y[X=1] - Y[X=0]".}

\item{given}{A character. A quoted expression that evaluates to a logical statement. Allows estimand to be conditioned on *observational* (or counterfactual) distribution.}

\item{using}{A character. Whether to use `priors`, `posteriors` or `parameters`.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.}

\item{stats}{Functions to be applied to estimand distribution. If `NULL`, defaults to mean and standard deviation.}

\item{digits}{An integer. Decimal digits in output table.}

\item{n_draws}{An integer. Number of draws.}

\item{expand_grid}{Logical. If \code{TRUE} then all combinations of provided lists are examined. If not then each list is cycled through separately. Defaults to `FALSE`.}

\item{query}{alias for queries}
}
\value{
A \code{data.frame} with columns `Query`, `Given` and `Using` defined by corresponding input values. Further columns are generated as specified in `stats`.
}
\description{
Calculated from a parameter vector, from a prior or from a posterior distribution
}
\examples{
model <- make_model("X -> Y") \%>\% set_prior_distribution(n_draws = 10000)

\donttest{
estimands_df <-query_model(
               model,
               query = list(ATE = "Y[X=1] - Y[X=0]", Share_positive = "Y[X=1] > Y[X=0]"),
               using = c("parameters", "priors"),
               expand_grid = TRUE)

estimands_df <-query_model(
               model,
               query = list(ATE = "Y[X=1] - Y[X=0]", Share_positive = "Y[X=1] > Y[X=0]"),
               using = c("parameters", "priors"),
               expand_grid = FALSE)

estimands_df <- query_model(
                model,
                using = list( "parameters", "priors"),
                query = list(ATE = "Y[X=1] - Y[X=0]", Is_B = "Y[X=1] > Y[X=0]"),
                given = list(TRUE,  "Y==0 & X==1"),
                expand_grid = TRUE,
                digits = 3)

# An example: a stat representing uncertainty of token causation
token_var <- function(x) mean(x)*(1-mean(x))
estimands_df <- query_model(
                model,
                using = list( "parameters", "priors"),
                query = "Y[X=1] > Y[X=0]",
                stats = c(mean = mean, sd = sd, token_var = token_var))
}
}
