% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_par_values.R
\name{make_par_values}
\alias{make_par_values}
\title{make_par_values}
\usage{
make_par_values(
  model,
  y = get_priors(model),
  x = NA,
  distribution = NA,
  node = NA,
  label = NA,
  statement = NA,
  confound = NA,
  nodal_type = NA,
  param_names = NA,
  param_set = NA,
  normalize = FALSE
)
}
\arguments{
\item{model}{A model created with \code{make_model}}

\item{y}{Vector of real non negative values to be changed}

\item{x}{Vector of real non negative values to be substituted into y}

\item{distribution}{String indicating a common prior distribution (uniform, jeffreys or certainty)}

\item{node}{A string indicating nodes for which priors are to be altered}

\item{label}{String. Label for nodal type indicating nodal types for which priors are to be altered}

\item{statement}{A causal query that determines nodal types for which priors are to be altered}

\item{confound}{A confound statement that restricts nodal types for which priors are to be altered}

\item{nodal_type}{String. Label for nodal type indicating nodal types for which priors are to be altered}

\item{param_names}{String. The name of specific parameter in the form of, for example, 'X.1', 'Y.01'}

\item{param_set}{String. Indicates the name of the set of parameters to be modified (useful when setting confounds)}

\item{normalize}{Logical. If TRUE normalizes such that param set probabilities sum to 1.}
}
\description{
This is the one step function for make_priors and make_parameters.
See \code{make_priors} for more help.
}
\details{
Forbidden statements include:
\itemize{
  \item Setting \code{distribution} and \code{values} at the same time.
  \item Setting a \code{distribution} other than uniform, jeffreys or certainty.
  \item Setting negative values.
}
}
\examples{
model <- make_model('X -> M -> Y; X -> Y')

CausalQueries:::make_par_values(model, distribution = 'jeffreys')

CausalQueries:::make_par_values(model, x = 3)

# Selecting subsets:

# By node
CausalQueries:::make_par_values(model, node = 'M', x = 8)

# By nodal type statement
CausalQueries:::make_par_values(model,
        statement = '(Y[X=1, M = .] > Y[X=0, M = .])', x = 2)

# By nodal type label (safest to provide node also)
CausalQueries:::make_par_values(model, node = 'X', label = '0', x = 9)

# By confound query: Applies only to types that are involved in confounding
# Only alters named node in confound, even if other nodes are listed in 'nodes'
confounds <- list(X = 'Y[X=1] > Y[X=0]', X = 'Y[X=1] < Y[X=0]')
model     <- make_model('X->Y') \%>\% set_confound(confounds)
CausalQueries:::make_par_values(model, confound = confounds[1], x = 3)
CausalQueries:::make_par_values(model, node = 'Y', confound = confounds[1], x = 3)

# A residual  confound condition can also be defined
CausalQueries:::make_par_values(model,
                                confound = list(X = '!(Y[X=1] > Y[X=0])'),
                                x = 3)
CausalQueries:::make_par_values(model,
                                confound = list(X = '(Y[X=1] == Y[X=0])'),
                                x = 3)

# make_par_values can also be used for some vector valued statements
model <- make_model('X -> M -> Y')
CausalQueries:::make_par_values(model, node = c('X', 'Y'), x = 2)
CausalQueries:::make_par_values(model, label = c('1', '01'), x = 2)

# Incompatible conditions produce no change
CausalQueries:::make_par_values(model, node = 'X', label = '01', x = 2)

# If statement not satisfied by any cases then no change
model <- make_model("X->Y")
CausalQueries:::make_par_values(model, statement = '(Y[X=1] == 2)', x = .1)

# Normalization: Take in a parameter vector and output is renormalized
model <- make_model("X->Y")
CausalQueries:::make_par_values(model,
                                y = get_parameters(model),
                                label = '01',
                                x = .1,
                                normalize = TRUE)
CausalQueries:::make_par_values(model,
                                y = get_parameters(model),
                                statement = '(Y[X=1] == Y[X=0])',
                                x = .1,
                                normalize = TRUE)

# Problematic examples
\dontrun{
CausalQueries:::make_par_values(model, x = 1:2)
CausalQueries:::make_par_values(model,
                                y = get_parameters(model),
                                label = '01',
                                x = 2,
                                normalize = TRUE)
}

}
\seealso{
Other priors: 
\code{\link{get_priors}()},
\code{\link{make_par_values_multiple}()},
\code{\link{make_priors}()},
\code{\link{make_values_task_list}()},
\code{\link{set_priors}()}
}
\concept{priors}
\keyword{internal}
