% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_fn.R
\name{matching_fn}
\alias{matching_fn}
\title{Match observations}
\usage{
matching_fn(
  w,
  dataset,
  exposure_col_name,
  e_gps_pred,
  e_gps_std_pred,
  w_resid,
  gps_mx,
  w_mx,
  dist_measure = "l1",
  gps_density = "normal",
  delta_n = 1,
  scale = 0.5,
  nthread = 1
)
}
\arguments{
\item{w}{the targeted single exposure levels.}

\item{dataset}{a completed observational data frame or matrix containing
(Y, w, gps, counter, row_index, c).}

\item{e_gps_pred}{a vector of predicted gps values obtained by Machine
learning methods.}

\item{e_gps_std_pred}{a vector of predicted std of gps obtained by
Machine learning methods.}

\item{w_resid}{the standardized residuals for w.}

\item{gps_mx}{a vector with length 2, includes min(gps), max(gps)}

\item{w_mx}{a vector with length 2, includes min(w), max(w).}

\item{gps_density}{Model type which is used for estimating GPS value, including
\code{normal} (default) and \code{kernel}.}

\item{delta_n}{a specified caliper parameter on the exposure (Default is 1).}

\item{scale}{a specified scale parameter to control the relative weight
that is attributed to
the distance measures of the exposure versus the GPS estimates
(Default is 0.5).}

\item{nthread}{Number of available cores.}
}
\value{
\code{dp}: The function returns a data.table saved the matched points on
by single exposure
level w by the proposed GPS matching approaches.
}
\description{
Matching function using L1 distance on single exposure level w
}
\keyword{internal}
