% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RF.R
\name{Carlson_RF}
\alias{Carlson_RF}
\title{Carlson elliptic integral RF}
\usage{
Carlson_RF(x, y, z, minerror = 1e-15)
}
\arguments{
\item{x, y, z}{real or complex numbers; at most one can be 0}

\item{minerror}{bound on relative error}
}
\value{
A complex number, the value of the Carlson elliptic integral
  \ifelse{html}{\out{R<sub>F</sub>(x,y,z)}}{\eqn{R_F(x,y,z)}{RF(x,y,z)}}.
}
\description{
Evaluate the Carlson elliptic integral RF.
}
\note{
The function returns a value when \code{x}, \code{y} or \code{z}
  are negative real numbers, but this value is not the one of the
  Carlson integral.
}
\examples{
Carlson_RF(5, 2, 3)
gsl::ellint_RF(5, 2, 3)
}
