% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/val.prob.ci.2.R
\name{val.prob.ci.2}
\alias{val.prob.ci.2}
\title{Calibration performance}
\usage{
val.prob.ci.2(
  p,
  y,
  logit,
  group,
  weights = rep(1, length(y)),
  normwt = FALSE,
  pl = TRUE,
  smooth = c("loess", "rcs", "none"),
  CL.smooth = "fill",
  CL.BT = FALSE,
  lty.smooth = 1,
  col.smooth = "black",
  lwd.smooth = 1,
  nr.knots = 5,
  logistic.cal = FALSE,
  lty.log = 1,
  col.log = "black",
  lwd.log = 1,
  xlab = "Predicted probability",
  ylab = "Observed proportion",
  xlim = c(-0.02, 1),
  ylim = c(-0.15, 1),
  m,
  g,
  cuts,
  emax.lim = c(0, 1),
  legendloc = c(0.5, 0.27),
  statloc = c(0, 0.85),
  dostats = TRUE,
  cl.level = 0.95,
  method.ci = "pepe",
  roundstats = 2,
  riskdist = "predicted",
  cex = 0.75,
  cex.leg = 0.75,
  connect.group = FALSE,
  connect.smooth = TRUE,
  g.group = 4,
  evaluate = 100,
  nmin = 0,
  d0lab = "0",
  d1lab = "1",
  cex.d01 = 0.7,
  dist.label = 0.04,
  line.bins = -0.05,
  dist.label2 = 0.03,
  cutoff,
  las = 1,
  length.seg = 1,
  y.intersp = 1,
  lty.ideal = 1,
  col.ideal = "red",
  lwd.ideal = 1,
  allowPerfectPredictions = FALSE,
  argzLoess = alist(degree = 2),
  ...
)
}
\arguments{
\item{p}{
predicted probability
}

\item{y}{
vector of binary outcomes
}

\item{logit}{
predicted log odds of outcome.  Specify either \code{p} or \code{logit}.
}

\item{group}{
a grouping variable.  If numeric this variable is grouped into
\code{g.group} quantile groups (default is quartiles).  Set \code{group=TRUE} to
use the \code{group} algorithm but with a single stratum for \code{val.prob}.
}

\item{weights}{
an optional numeric vector of per-observation weights (usually frequencies),
used only if \code{group} is given.
}

\item{normwt}{
set to \code{TRUE} to make \code{weights} sum to the number of non-missing observations.
}

\item{pl}{\code{TRUE} to plot the calibration curve(s). If \code{FALSE} no calibration curves will be plotted,
but statistics will still be computed and outputted.}

\item{smooth}{\code{"loess"} generates a flexible calibration curve based on \code{\link{loess}},
\code{"rcs"} generates a calibration curves based on restricted cubic splines (see \code{\link[rms]{rcs}} and
\code{\link[Hmisc]{rcspline.plot}}), \code{"none"} suppresses the flexible curve. We recommend to use loess unless N is large,
 for example N>5000. Default is \code{"loess"}.}

\item{CL.smooth}{\code{"fill"} shows pointwise 95\% confidence limits for the flexible calibration curve with a gray
area between the lower and upper limits, \code{TRUE} shows pointwise 95\% confidence limits for the flexible calibration curve
 with dashed lines, \code{FALSE} suppresses the confidence limits. Default is \code{"fill"}.}

\item{CL.BT}{\code{TRUE} uses confidence limits based on 2000 bootstrap samples, \code{FALSE} uses closed form confidence limits.
Default is \code{FALSE}.}

\item{lty.smooth}{the linetype of the flexible calibration curve. Default is \code{1}.}

\item{col.smooth}{the color of the flexible calibration curve. Default is \code{"black"}.}

\item{lwd.smooth}{the line width of the flexible calibration curve. Default is \code{1}.}

\item{nr.knots}{specifies the number of knots for rcs-based calibration curve. The default as well as the highest allowed value is 5.
In case the specified number of knots leads to estimation problems, then the number of knots is automatically reduced to the closest
 value without estimation problems.}

\item{logistic.cal}{\code{TRUE} plots the logistic calibration curve, \code{FALSE} suppresses this curve.
Default is \code{FALSE}.}

\item{lty.log}{if \code{logistic.cal=TRUE}, the linetype of the logistic calibration curve. Default is \code{1}.}

\item{col.log}{if \code{logistic.cal=TRUE}, the color of the logistic calibration curve. Default is \code{"black"}.}

\item{lwd.log}{if \code{logistic.cal=TRUE}, the line width of the logistic calibration curve. Default is \code{1}.}

\item{xlab}{x-axis label, default is \code{"Predicted Probability"}.}

\item{ylab}{y-axis label, default is \code{"Observed proportion"}.}

\item{xlim, ylim}{numeric vectors of length 2, giving the x and y coordinates ranges (see \code{\link{plot.window}})}

\item{m}{
If grouped proportions are desired, minimum no. observations per group
}

\item{g}{
If grouped proportions are desired, number of quantile groups
}

\item{cuts}{
If grouped proportions are desired, actual cut points for constructing
intervals, e.g. \code{c(0,.1,.8,.9,1)} or \code{seq(0,1,by=.2)}
}

\item{emax.lim}{
Vector containing lowest and highest predicted probability over which to
compute \code{Emax}.
}

\item{legendloc}{if \code{pl=TRUE}, list with components \code{x,y} or vector \code{c(x,y)} for bottom right corner of legend for
curves and points. Default is \code{c(.50, .27)} scaled to lim. Use \code{locator(1)} to use the mouse, \code{FALSE} to suppress legend.}

\item{statloc}{the "abc" of model performance (Steyerberg et al., 2011)-calibration intercept, calibration slope,
and c statistic-will be added to the plot, using statloc as the upper left corner of a box (default is c(0,.85).
You can specify a list or a vector. Use locator(1) for the mouse, \code{FALSE} to suppress statistics. This is plotted after
the curve legends.}

\item{dostats}{specifies whether and which performance measures are shown in the figure.
\code{TRUE} shows the \code{"abc"} of model performance (Steyerberg et al., 2011): calibration intercept, calibration slope,
 and c-statistic. \code{TRUE} is default.
 \code{FALSE} suppresses the presentation of statistics in the figure. A \code{c()} list of specific stats shows the specified
 stats. The key stats which are also mentioned in this paper are \code{"C (ROC)"} for the c statistic, \code{"Intercept"} for the
 calibration intercept, \code{"Slope"} for the calibration slope, and \code{"ECI"} for the estimated calibration index
 (Van Hoorde et al, 2015). The full list of possible statistics is taken from \code{\link[rms]{val.prob}}
 and augmented with the estimated calibration index: \code{"Dxy", "C (ROC)", "R2", "D", "D:Chi-sq", "D:p", "U", "U:Chi-sq",
  "U:p", "Q", "Brier", "Intercept", "Slope", "Emax", "Brier scaled", "Eavg", "ECI"}. These statistics are always returned by the function.}

\item{cl.level}{if \code{dostats=TRUE}, the confidence level for the calculation of the confidence intervals of the calibration intercept,
calibration slope and c-statistic. Default is \code{0.95}.}

\item{method.ci}{method to calculate the confidence interval of the c-statistic. The argument is passed to \code{\link{auc.nonpara.mw}} from
the auRoc-package and possible methods to compute the confidence interval are \code{"newcombe"}, \code{"pepe"}, \code{"delong"} or
\code{"jackknife"}. Bootstrap-based methods are not available. The default method is \code{"pepe"} and here, the confidence interval is
the logit-transformation-based confidence interval as documented in Qin and Hotilovac (2008). See \code{\link{auc.nonpara.mw}} for
more information on the other methods.}

\item{roundstats}{specifies the number of decimals to which the statistics are rounded when shown in the plot. Default is 2.}

\item{riskdist}{
Use \code{"calibrated"} to plot the relative frequency distribution of
calibrated probabilities after dividing into 101 bins from \code{lim[1]} to
\code{lim[2]}.
Set to \code{"predicted"} (the default as of rms 4.5-1) to use raw assigned risk, \code{FALSE} to omit risk distribution.
Values are scaled so that highest bar is \code{0.15*(lim[2]-lim[1])}.
}

\item{cex, cex.leg}{controls the font size of the statistics (\code{cex}) or plot legend (\code{cex.leg}). Default is 0.75}

\item{connect.group}{
Defaults to \code{FALSE} to only represent group fractions as triangles.
Set to \code{TRUE} to also connect with a solid line.
}

\item{connect.smooth}{Defaults to \code{TRUE} to draw smoothed estimates using a line. Set to \code{FALSE} to instead use dots at individual estimates}

\item{g.group}{
number of quantile groups to use when \code{group} is given and variable is
numeric.
}

\item{evaluate}{
number of points at which to store the \code{lowess}-calibration curve.
Default is 100.  If there are more than \code{evaluate} unique predicted
probabilities, \code{evaluate} equally-spaced quantiles of the unique
predicted probabilities, with linearly interpolated calibrated values,
are retained for plotting (and stored in the object returned by
\code{val.prob}.
}

\item{nmin}{
applies when \code{group} is given.  When \code{nmin} \eqn{> 0}, \code{val.prob} will not
store coordinates of smoothed calibration curves in the outer tails,
where there are fewer than \code{nmin} raw observations represented in
those tails.  If for example \code{nmin}=50, the \code{plot} function will only
plot the estimated calibration curve from \eqn{a} to \eqn{b}, where there are
50 subjects with predicted probabilities \eqn{< a} and \eqn{> b}.
\code{nmin} is ignored when computing accuracy statistics.
}

\item{d0lab, d1lab}{controls the labels for events and non-events (i.e. outcome y) for the histograms.
Defaults are \code{d1lab="1"} for events and \code{d0lab="0"} for non-events.}

\item{cex.d01}{controls the size of the labels for events and non-events. Default is 0.7.}

\item{dist.label}{controls the horizontal position of the labels for events and non-events. Default is 0.04.}

\item{line.bins}{controls the horizontal (y-axis) position of the histograms. Default is -0.05.}

\item{dist.label2}{controls the vertical distance between the labels for events and non-events. Default is 0.03.}

\item{cutoff}{puts an arrow at the specified risk cut-off(s). Default is none.}

\item{las}{controls whether y-axis values are shown horizontally (1) or vertically (0).}

\item{length.seg}{controls the length of the histogram lines. Default is \code{1}.}

\item{y.intersp}{character interspacing for vertical line distances of the legend (\code{\link{legend}})}

\item{lty.ideal}{linetype of the ideal line. Default is \code{1}.}

\item{col.ideal}{controls the color of the ideal line on the plot. Default is \code{"red"}.}

\item{lwd.ideal}{controls the line width of the ideal line on the plot. Default is \code{1}.}

\item{allowPerfectPredictions}{Logical, indicates whether perfect predictions (i.e. values of either 0 or 1) are allowed. Default is \code{FALSE}, since we transform
the predictions using the logit transformation to calculate the calibration measures. In case of 0 and 1, this results in minus infinity and infinity, respectively. if
\code{allowPerfectPredictions = TRUE}, 0 and 1 are replaced by 1e-8 and 1 - 1e-8, respectively.}

\item{argzLoess}{a list with arguments passed to the \code{\link{loess}} function}

\item{...}{arguments to be passed to \code{\link{plot}}, see \code{\link{par}}}
}
\value{
An object of type \code{CalibrationCurve} with the following slots:

\item{call}{the matched call.}

\item{stats}{a vector containing performance measures of calibration.}

\item{cl.level}{the confidence level used.}

\item{Calibration}{contains the calibration intercept and slope, together with their confidence intervals.}

\item{Cindex}{the value of the c-statistic, together with its confidence interval.}

\item{warningMessages}{if any, the warning messages that were printed while running the function.}

\item{CalibrationCurves}{The coordinates for plotting the calibration curves. }
}
\description{
The function \code{val.prob.ci.2} is an adaptation of \code{\link[rms]{val.prob}} from Frank Harrell's rms package,
\url{https://cran.r-project.org/package=rms}. Hence, the description of some of the functions of \code{val.prob.ci.2}
come from the the original \code{\link[rms]{val.prob}}.
\cr \cr The key feature of \code{val.prob.ci.2} is the generation of logistic and flexible calibration curves and related statistics.
When using this code, please cite: Van Calster, B., Nieboer, D., Vergouwe, Y., De Cock, B., Pencina, M.J., Steyerberg,
E.W. (2016). A calibration hierarchy for risk models was defined: from utopia to empirical data. \emph{Journal of Clinical Epidemiology},
\bold{74}, pp. 167-176
}
\details{
When using the predicted probabilities of an uninformative model (i.e. equal probabilities for all observations), the model has no predictive value.
 Consequently, where applicable, the value of the performance measure corresponds to the worst possible theoretical value. For the ECI, for example, this equals 1 (Edlinger et al., 2022).
}
\note{
In order to make use (of the functions) of the package auRoc, the user needs to install JAGS. However, since our package only uses the
\code{auc.nonpara.mw} function which does not depend on the use of JAGS, we therefore copied the code and slightly adjusted it when
\code{method="pepe"}.
}
\examples{

# Load package
library(CalibrationCurves)
set.seed(1783)

# Simulate training data
X      = replicate(4, rnorm(5e2))
p0true = binomial()$linkinv(cbind(1, X) \%*\% c(0.1, 0.5, 1.2, -0.75, 0.8))
y      = rbinom(5e2, 1, p0true)
Df     = data.frame(y, X)

# Fit logistic model
FitLog = lrm(y ~ ., Df)

# Simulate validation data
Xval   = replicate(4, rnorm(5e2))
p0true = binomial()$linkinv(cbind(1, Xval) \%*\% c(0.1, 0.5, 1.2, -0.75, 0.8))
yval   = rbinom(5e2, 1, p0true)
Pred   = binomial()$linkinv(cbind(1, Xval) \%*\% coef(FitLog))

# Default calibration plot
val.prob.ci.2(Pred, yval)

# Adding logistic calibration curves and other additional features
val.prob.ci.2(Pred, yval, CL.smooth = TRUE, logistic.cal = TRUE, lty.log = 2,
 col.log = "red", lwd.log = 1.5)

val.prob.ci.2(Pred, yval, CL.smooth = TRUE, logistic.cal = TRUE, lty.log = 9,
col.log = "red", lwd.log = 1.5, col.ideal = colors()[10], lwd.ideal = 0.5)
}
\references{
Edlinger, M, van Smeden, M, Alber, HF, Wanitschek, M, Van Calster, B. (2022). Risk prediction models for discrete ordinal outcomes: Calibration and the impact of the proportional odds assumption. \emph{Statistics in Medicine}, \bold{41( 8)}, pp. 1334– 1360

Qin, G., & Hotilovac, L. (2008). Comparison of non-parametric confidence intervals for the area under the ROC curve of a continuous-scale diagnostic test. \emph{Statistical Methods in Medical Research}, \bold{17(2)}, pp. 207-21

Steyerberg, E.W., Van Calster, B., Pencina, M.J. (2011). Performance measures for prediction models and markers : evaluation of predictions and classifications. \emph{Revista Espanola de Cardiologia}, \bold{64(9)}, pp. 788-794

Van Calster, B., Nieboer, D., Vergouwe, Y., De Cock, B., Pencina M., Steyerberg E.W. (2016). A calibration hierarchy for risk models was defined: from utopia to empirical data. \emph{Journal of Clinical Epidemiology}, \bold{74}, pp. 167-176

Van Hoorde, K., Van Huffel, S., Timmerman, D., Bourne, T., Van Calster, B. (2015). A spline-based tool to assess and visualize the calibration of multiclass risk predictions. \emph{Journal of Biomedical Informatics}, \bold{54}, pp. 283-93
}
