% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{multivariate}
\alias{multivariate}
\title{Simulate from a Multivariate Normal Distribution}
\usage{
multivariate(n = 1, mu, Sigma, tol = 1e-06, empirical = FALSE,
  EISPACK = FALSE)
}
\arguments{
\item{n}{the number of samples required.}

\item{mu}{a vector giving the means of the variables.}

\item{Sigma}{a positive-definite symmetric matrix specifying the covariance matrix of the variables.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma.}

\item{empirical}{logical. If true, mu and Sigma specify the empirical not population mean and covariance matrix.}

\item{EISPACK}{logical: values other than FALSE are an error.}
}
\value{
If n = 1 a vector of the same length as mu, otherwise an n by length(mu) matrix with one sample in each row.
}
\description{
The matrix decomposition is done via eigen; although a Choleski decomposition might be faster,
the eigen decomposition is stabler.
}
