% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{norm,Expression,character-method}
\alias{norm,Expression,character-method}
\alias{norm}
\title{Matrix Norm}
\usage{
\S4method{norm}{Expression,character}(x, type)
}
\arguments{
\item{x}{An \linkS4class{Expression}.}

\item{type}{A character indicating the type of norm desired.
\itemize{
   \item "O", "o" or "1" specifies the 1-norm (maximum absolute column sum).
   \item "I" or "i" specifies the infinity-norm (maximum absolute row sum).
   \item "F" or "f" specifies the Frobenius norm (Euclidean norm of the vectorized \code{x}).
   \item "M" or "m" specifies the maximum modulus of all the elements in \code{x}.
   \item "2" specifies the spectral norm, which is the largest singular value of \code{x}.
}}
}
\value{
An \linkS4class{Expression} representing the norm of the input.
}
\description{
The matrix norm, which can be the 1-norm ("1"), infinity-norm ("I"), Frobenius norm ("F"), maximum modulus of all the entries ("M"), or the spectral norm ("2"), as determined by the value of type.
}
\examples{
C <- Variable(3,2)
val <- Constant(rbind(c(1,2), c(3,4), c(5,6)))
prob <- Problem(Minimize(norm(C, "F")), list(C == val))
result <- solve(prob, solver = "SCS")
result$value
}
\seealso{
The \code{\link{p_norm}} function calculates the vector p-norm.
}
