% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cub0q.R
\name{cub0q}
\alias{cub0q}
\title{Main function for CUB models with covariates for the feeling component}
\usage{
cub0q(m, ordinal, W, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates for explaining the feeling component, not including intercept}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUB"
}
\description{
Function to estimate and validate a CUB model for given ordinal responses, with covariates for
 explaining the feeling component.
}
\examples{
#running donttest option since the proposed examples require a long time run for check
\donttest{
data(relgoods)
m=10
ordinal=relgoods[,29]
gender=relgoods[,2]
data=na.omit(cbind(ordinal,gender))
ordinal=data[,1]
W=data[,2]
makeplot=TRUE
maxiter=500
toler=1e-6
cubfit=cub0q(m,ordinal,W, maxiter, toler, makeplot, summary=TRUE)
param=cubfit$estimates      # Final ML estimates
pai=param[1]                # Estimated uncertainty parameter
gama=param[2:length(param)] # Estimated coefficients for feeling covariates
maxlik=cubfit$loglik
varmat=cubfit$varmat
niter=cubfit$niter
BIC=cubfit$BIC
###########################
data(univer)
m=7
global=univer[,12]
freqserv=univer[,2]
vercub0q=cub0q(m,global,W=freqserv,maxiter=300,toler=1e-4,makeplot=FALSE)
param=vercub0q$estimates      # Final ML estimates
pai=param[1]                  # Estimated uncertainty parameter
gama=param[2:length(param)]   # Estimated coefficients for feeling covariates
maxlik=vercub0q$loglik
varmat=vercub0q$varmat
niter=vercub0q$niter
BIC=vercub0q$BIC
}
}
\references{
Piccolo D. and D'Elia A. (2008), A new approach for modelling consumers' preferences,
  \emph{Food Quality and Preference}, \bold{18}, 247--259 \cr

Iannario M. and Piccolo D. (2010), A new statistical model for the analysis of customer
 satisfaction, #' \emph{Quality Technology and Quantity management}, \bold{7}(2) 149--168 \cr
Iannario M. and Piccolo D. (2012), CUB models: Statistical methods and empirical evidence, in:
Kenett R. S. and Salini S. (eds.), \emph{Modern Analysis of Customer Surveys: with applications using R},
 J. Wiley and Sons, Chichester, 231--258.
}
\keyword{internal}

