% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubecsi.R
\name{cubecsi}
\alias{cubecsi}
\title{Main function for CUBE models with covariates only for feeling}
\usage{
cubecsi(m, ordinal, W, starting, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{starting}{Vector of initial parameters estimates to start the optimization algorithm, with length equal to
NCOL(W) + 3 to account for an intercept term for the feeling component (first entry)}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUBE". For cubecsi, $niter will return a NULL value since the optimization procedure
 is not iterative but based on "optim" (method = "L-BFGS-B", option hessian=TRUE). \cr $varmat will return the inverse 
 of the numerically computed Hessian when it is positive definite, otherwise the procedure will return a matrix of NA
  entries.
}
\description{
Estimate and validate a CUBE model for ordinal data, with covariates only for explaining the
feeling component.
}
\seealso{
\code{\link{loglikcubecsi}},  \code{\link{inibestcubecsi}},  \code{\link{CUBE}}
}
\keyword{#models}
\keyword{internal}
