% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cubvisual.R
\name{cubvisual}
\alias{cubvisual}
\title{Plot an estimated CUB model}
\usage{
cubvisual(ordinal,csiplot=FALSE,paiplot=FALSE,...)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{csiplot}{Logical: should \eqn{\xi} or \eqn{1-\xi} be the \eqn{y} coordinate}

\item{paiplot}{Logical: should \eqn{\pi} or \eqn{1-\pi} be the \eqn{x} coordinate}

\item{...}{Additional arguments to be passed to \code{plot()} and \code{text()}. Optionally, the number
\code{m} of ordinal categories may be passed: this is recommended if some category has zero frequency.}
}
\value{
For a CUB model fit to \code{ordinal}, by default it returns a plot of the estimated
\eqn{(1-\pi, 1-\xi)} as a point in the parameter space. Depending on \code{csiplot} and \code{paiplot}
and on desired output, \eqn{x} and \eqn{y} coordinates may be set to \eqn{\pi} and \eqn{\xi}, respectively.
}
\description{
Plotting facility for the CUB estimation of ordinal responses.
}
\details{
It represents an estimated CUB model as a point
 in the parameter space with some useful options.
}
\examples{
data(univer)
ordinal<-univer$global
cubvisual(ordinal,xlim=c(0,0.5),ylim=c(0.5,1),cex=0.8,main="Global Satisfaction")
}
\keyword{device}

