% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikCUB.R
\name{loglikCUB}
\alias{loglikCUB}
\title{Log-likelihood function for CUB models}
\usage{
loglikCUB(ordinal,m,param,Y=0,W=0,shelter=0)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUB model}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included 
in the model)}

\item{W}{Matrix of selected covariates to explain the feeling component (default: no covariate is included 
in the model)}

\item{shelter}{Category corresponding to the shelter choice (default: no shelter effect is included in the 
model)}
}
\description{
Compute the log-likelihood function for CUB models with or without covariates to 
explain the feeling and uncertainty components, or for extended CUB models with shelter effect.
}
\details{
If no covariate is included in the model, then "param" has the form \eqn{(\pi,\xi)}. More generally, 
it has the form \eqn{(\beta,\gamma)} where, respectively, \eqn{\beta} and \eqn{\gamma} are the vectors of 
coefficients explaining the uncertainty and the feeling components, with length NCOL(Y)+1 and
 NCOL(W)+1 to account for an intercept term in the first entry.
}
\examples{
## Log-likelihood of a CUB model with no covariate
m<-9; n<-300
pai<-0.6; csi<-0.4
ordinal<-simcub(n,m,pai,csi)
param<-c(pai,csi)
loglikcub<-loglikCUB(ordinal,m,param)
##################################
## Log-likelihood of a CUB model with covariate for uncertainty
\donttest{
data(relgoods)
m<-10
ordinal<-relgoods[,29]
gender<-relgoods[,2]
data<-na.omit(cbind(ordinal,gender))
ordinal<-data[,1]; Y<-data[,2]
bbet<-c(-0.81,0.93); ccsi<-0.2
param<-c(bbet,ccsi)
loglikcubp0<-loglikCUB(ordinal,m, param, Y=Y)
#######################
## Log-likelihood of a CUB model with covariate for feeling
data(relgoods)
m<-10
ordinal<-relgoods[,29]
gender<-relgoods[,2]
data<-na.omit(cbind(ordinal,gender))
ordinal<-data[,1]; W<-data[,2]
pai<-0.44; gama<- c(-0.91, -0.7)
param<-c(pai,gama)
loglikcub0q<-loglikCUB(ordinal,m,param,W=W)
}
#######################
## Log-likelihood of a CUB model with covariates for both parameters
data(relgoods)
m<-10;
smoking<-relgoods[,12]
ordinal<-relgoods[,40]
gender<-relgoods[,2]
nona<-na.omit(cbind(ordinal,gender,smoking))
ordinal<-nona[,1]
gender<-nona[,2]; smoking<-nona[,3]
bet=c(-0.45, -0.48); gama=c(-0.55, -0.43)
param<-c(bet,gama)
loglikcubpq<-loglikCUB(ordinal,m,param, Y=smoking, W=gender)
#################################
### Log-likelihood of a CUB model with shelter effect
m<-7; n<-400
pai1<-0.56; pai2<-0.34; csi<-0.16
shelter<-5
pr<-probcubshe1(m,pai1,pai2,csi,shelter)
ordinal<-sample(1:m,n,prob=pr,replace=TRUE)
param<-c(pai1, pai2, csi)
loglik<-loglikCUB(ordinal,m,param,shelter=shelter)
}
\seealso{
\code{\link{CUB}}, \code{\link{cubforsim}}
}
\keyword{htest}

