% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.netWalkSnapShot.r
\name{graph.netWalkSnapShot}
\alias{graph.netWalkSnapShot}
\title{Capture the current location of a network walker}
\usage{
graph.netWalkSnapShot(adj_mat,G,output_dir,p1,visitedNodes,S,
                                coords,imgNum=1,useLabels=TRUE)
}
\arguments{
\item{adj_mat}{- The adjacency matrix that encodes the edge weights for
the network, G.}

\item{G}{- A list of probabilities, with names of the list being the node
names in the network.}

\item{output_dir}{- The local directory at which you want still PNG images
to be saved.}

\item{p1}{- The probability being dispersed from the starting node, 
startNode, which is preferentially distributed between network 
nodes by the probability diffusion algorithm based solely on 
network connectivity.}

\item{visitedNodes}{- A character vector of node names, storing the history
of previous draws in the node ranking.}

\item{S}{- A character vector of node names in the subset you want the
network walker to find.}

\item{coords}{- The x and y coordinates for each node in the network, to 
remain static between images.}

\item{imgNum}{- The image number for this snapshot. If images are being 
generated in a sequence, this serves as an iterator for file
naming.}

\item{useLabels}{- If TRUE, node names will display next to their respective 
nodes in the network. If FALSE, node names will not
display.}
}
\value{
0
}
\description{
A network walker steps towards the node that inherited the highest
probability from the last node that it stepped into.
}
\examples{
# 7 node example graph illustrating diffusion of probability based on network
# connectivity
adj_mat = rbind(c(0,2,1,0,0,0,0), # A
                c(2,0,1,0,0,0,0), # B
                c(1,0,0,1,0,0,0), # C
                c(0,0,1,0,2,0,0), # D
                c(0,0,0,2,0,2,1), # E
                c(0,0,0,1,2,0,1), # F
                c(0,0,0,0,1,1,0)  # G
                )
rownames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
colnames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
ig = graph.adjacency(as.matrix(adj_mat), mode="undirected", weighted=TRUE)
G=vector(mode="list", length=7)
G[seq_len(length(G))] = 0
names(G) = c("A", "B", "C", "D", "E", "F", "G")
S = c("A", "C")
coords = layout.fruchterman.reingold(ig)
# Uncomment to run
#graph.netWalkSnapShot(adj_mat,G,output_dir=getwd(),p1=1.0,
#                        "A",S,coords,1,TRUE)
}
