% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.combineData.r
\name{data.combineData}
\alias{data.combineData}
\title{Combine datasets}
\usage{
data.combineData(curr_data, more_data)
}
\arguments{
\item{curr_data}{- Current data matrix}

\item{more_data}{- Data matrix you want to combine with curr_data.}
}
\value{
combined.data - Combined data matrix.
}
\description{
Combine datasets
}
\examples{
# Row names and column names are required for both input matrices.
curr_data=matrix(rnorm(500), ncol=100)
rownames(curr_data)=sprintf("Feature\%d",sample(seq_len(20), 
                                nrow(curr_data),replace = FALSE))
colnames(curr_data)=sprintf("Sample\%d", seq_len(ncol(curr_data)))
more_data=matrix(rnorm(500), ncol=100)
rownames(more_data)=sprintf("Feature\%d",sample(seq_len(20), 
                                nrow(curr_data),replace = FALSE))
colnames(more_data) = sprintf("Sample\%d", seq_len(ncol(curr_data)))
combined.data = data.combineData(curr_data, more_data)
}
