% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodVariance.R
\name{PeriodVariance}
\alias{PeriodVariance}
\title{Period Variance on multidimensional array objects}
\usage{
PeriodVariance(
  data,
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions.}

\item{dates}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions on parameter 'data'. By default it is NULL, to  
select aperiod this parameter must be provided.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'time'. More than one 
dimension name matching the dimensions provided in the object 
\code{data$data} can be specified.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the 
indicator in the element \code{data}.
}
\description{
Period Variance computes the average (var) of a given variable in a period.
Two bioclimatic indicators can be obtained by using this function:
\itemize{
 \item{'BIO4', (Providing temperature data) Temperature Seasonality 
       (Standard Deviation). The amount of temperature variation  
       over a given year (or averaged years) based on the standard 
       deviation (variation) of monthly temperature averages.}
 \item{'BIO15', (Providing precipitation data) Precipitation Seasonality 
       (CV). This is a measure of the variation in monthly precipitation 
       totals over the course of the year. This index is the ratio of the 
       standard deviation of the monthly total precipitation to the mean 
       monthly total precipitation (also known as the coefficient of 
       variation) and is expressed as a percentage.}
}
}
\examples{
data <- array(rnorm(45), dim = c(member = 7, sdate = 4, time = 3))
Dates <- c(seq(as.Date("2000-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2001-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2001-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2002-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2002-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2003-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"),
          seq(as.Date("2003-11-01", "\%Y-\%m-\%d", tz = "UTC"), 
              as.Date("2004-01-01", "\%Y-\%m-\%d", tz = "UTC"), by = "month"))
dim(Dates) <- c(sdate = 4, time = 3)
res <- PeriodVariance(data, dates = Dates, start = list(01, 12), end = list(01, 01))

}
