% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbsToProbs.R
\name{CST_AbsToProbs}
\alias{CST_AbsToProbs}
\title{Transform ensemble forecast into probabilities}
\usage{
CST_AbsToProbs(
  data,
  start = NULL,
  end = NULL,
  time_dim = "time",
  memb_dim = "member",
  sdate_dim = "sdate",
  ncores = NULL
)
}
\arguments{
\item{data}{An 's2dv_cube' object as provided function \code{CST_Start} or 
\code{CST_Load} in package CSTools.}

\item{start}{An optional parameter to define the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to define the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'time'. More than one dimension name 
matching the dimensions provided in the object \code{data$data} can be 
specified. This dimension is required to subset the data in a requested 
period.}

\item{memb_dim}{A character string indicating the name of the dimension in 
which the ensemble members are stored.}

\item{sdate_dim}{A character string indicating the name of the dimension in 
which the initialization dates are stored.}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
An 's2dv_cube' object containing the probabilites in the element \code{data}.
}
\description{
The Cumulative Distribution Function of a forecast is used to obtain the 
probabilities of each value in the ensemble. If multiple initializations 
(start dates) are provided, the function will create the Cumulative 
Distribution Function excluding the corresponding initialization.
}
\examples{
exp <- NULL
exp$data <- array(rnorm(216), dim = c(dataset = 1, member = 2, sdate = 3, 
                 time = 9, lat = 2, lon = 2))
class(exp) <- 's2dv_cube'
exp_probs <- CST_AbsToProbs(exp)
exp$data <- array(rnorm(5 * 3 * 214 * 2),
                 c(member = 5, sdate = 3, time = 214, lon = 2)) 
exp$attrs$Dates <- c(seq(as.Date("01-05-2000", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2000", format = "\%d-\%m-\%Y"), by = 'day'),
                    seq(as.Date("01-05-2001", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2001", format = "\%d-\%m-\%Y"), by = 'day'),
                    seq(as.Date("01-05-2002", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2002", format = "\%d-\%m-\%Y"), by = 'day'))
dim(exp$attrs$Dates) <- c(time = 214, sdate = 3)
exp_probs <- CST_AbsToProbs(data = exp, start = list(21, 4), end = list(21, 6))
}
