% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_regime_plot.R
\name{ch_regime_plot}
\alias{ch_regime_plot}
\title{Plots the regime of daily streamflows using quantiles}
\usage{
ch_regime_plot(
  DF,
  wyear = 1,
  colour = TRUE,
  mx = 1,
  metadata = NULL,
  quant = c(0.95, 0.9, 0.75, 0.5, 0.25, 0.1, 0.05)
)
}
\arguments{
\item{DF}{data frame of daily flow data}

\item{wyear}{set \code{wyear = 10} for October, \code{water year = 1} for calendar year, can be any month}

\item{colour}{if \code{TRUE} plot is in colour, if \code{FALSE} plot is grayscale.}

\item{mx}{set the maximum y value; if = 1 then maximum value of the flows is used to set}

\item{metadata}{a data frame of metadata, defaults to HYDAT_list.
the y-axis value. The value of \code{mx} can be specified to produce a series of plots with the 
same scale.}

\item{quant}{quantiles; default is \code{quant = c(0.95,0.9,0.75,0.5,0.25,0.1,0.05)}. 
Can be changed but the length must be 7 and the 4th value must be 0.5 (median)}
}
\value{
No value is returned; a standard \R graphic is created.
}
\description{
Produces a regime hydrograph similar to that in the reference. It shows the flow quantiles for each
day of the year and the maximum and minimum. Parameters can be set to change colours and set the y-scale
to allow plots of same scale to be produced.
}
\examples{
data(CAN05AA008)
ch_regime_plot(CAN05AA008, colour = TRUE, wyear = 1)

}
\references{
MacCulloch, G. and P. H. Whitfield (2012). Towards a Stream Classification System 
for the Canadian Prairie Provinces. Canadian Water Resources Journal 37: 311-332.
}
\author{
Paul Whitfield
}
