% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_get_AHCCD_monthly.R
\name{ch_get_AHCCD_monthly}
\alias{ch_get_AHCCD_monthly}
\title{Retrieve AHCCD data from EC datamart}
\usage{
ch_get_AHCCD_monthly(
  station,
  province,
  variable,
  url = "http://dd.weather.gc.ca/climate/ahccd/geojson/historical/monthly/"
)
}
\arguments{
\item{station}{Required. The station number - either as numeric or as a string.}

\item{province}{Required. Name of province/territory. Must one of AB, BC, MB, NB, NL, NS, NT, NU, ON, PE, QC, SK, YT.}

\item{variable}{Required. Must be one of 
\describe{
 \item{variable}{meaning}
 \item{PCP}{total precipitation}
 \item{RA}{rainfall}
 \item{SN}{snowfall}
 \item{TMAX}{max air temp}
 \item{TMEAN}{mean air temp}
 \item{TMIN}{max air temp}
 \item{PSFC}{surface air pressure}
 \item{SFCWND}{surface wind speed}
 \item{SLP}{sea level pressure}
 }}

\item{url}{Required. The default url currently works to access the data on the 
Environment Canada server. The url can be changed in case the site is moved.}
}
\value{
Returns a data frame with the monthly values and associated variables.
}
\description{
Retrieve AHCCD data from EC datamart
}
\note{
Not all variables are available at all stations. Attempting to retrieve a non-existent variable 
will result in an error message being displayed.
}
\examples{
stoon_monthly_precip <- ch_get_AHCCD_monthly("4057120", "SK", "PCP")
}
\references{
Use of the data must cite \cite{Mekis, E and L.A. Vincent, 2011: An overview of 
the second generation adjusted daily temperature and precipitation dataset for trend analysis in Canada. 
Atmosphere-Ocean, 49 (2), 163-177.}
}
\seealso{
\code{\link{ch_read_AHCCD_daily}} \code{\link{ch_read_AHCCD_monthly}}
}
\author{
Kevin Shook
}
