% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_csgo.R
\name{theme_csgo}
\alias{theme_csgo}
\title{CSGo theme}
\usage{
theme_csgo(...)
}
\arguments{
\item{...}{all available options of the \code{theme} function from \code{ggplot2}}
}
\value{
\code{theme} object
}
\description{
A CSGo theme to be used with \code{ggplot2}
}
\examples{
\dontrun{
library(CSGo)
library(ggplot2)
library(dplyr)
library(showtext)

## Loading Google fonts (https://fonts.google.com/)
font_add_google("Quantico", "quantico")

df \%>\%
 top_n(n = 10, wt = value) \%>\%
 ggplot(aes(x = name_match, y = value, fill = name_match)) +
 geom_col() +
 ggtitle("KILLS BY WEAPON") +
 ylab("Number of Kills") +
 xlab("") +
 labs(fill = "Weapon Name") +
 theme_csgo(text = element_text(family = "quantico"))

}
}
