% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats_user.R
\name{get_stats_user}
\alias{get_stats_user}
\title{Get the User Statistics}
\usage{
get_stats_user(api_key, user_id)
}
\arguments{
\item{api_key}{string with the key provided by the steam API.

PS: If you don`t have a API key yet go to \url{https://steamcommunity.com/login/home/?goto=\%2Fdev\%2Fapikey} and follow the presented steps.}

\item{user_id}{string with the steam user ID.

Steam ID is the NUMBER OR NAME at the end of your steam profile URL. ex: '76561198263364899'.

PS: The user should have a public status.}
}
\value{
data frame with all the CS Go statistics (divided in categories and subcategories) of the user ID.
}
\description{
This function will return the complete CS Go Statistics of the user_id (input).
}
\details{
Similar to the csgo_api_stats function but it will return a clean data frame with category and description of each statistic.
}
\examples{
\dontrun{
## It is necessary to fill the "api_key" parameter to run the example

df <- get_stats_user(api_key = 'XXX', user_id = '76561198263364899')
}
}
