% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRTsp.R
\name{CRTsp}
\alias{CRTsp}
\title{Create or update a \code{"CRTsp"} object}
\usage{
CRTsp(
  x = NULL,
  design = NULL,
  geoscale = NULL,
  locations = NULL,
  kappa = NULL,
  mu = NULL,
  geometry = "point"
)
}
\arguments{
\item{x}{an object of class \code{"CRTsp"} or a data frame containing locations in (x,y) coordinates, cluster
assignments (factor \code{cluster}), and arm assignments (factor \code{arm}). Optionally specification of a buffer zone (logical \code{buffer});
any other variables required for subsequent analysis.}

\item{design}{list: an optional list containing the requirements for the power of the trial}

\item{geoscale}{numeric: standard deviation of random displacement from each settlement cluster center (for new objects)}

\item{locations}{integer: number of locations in population (for new objects)}

\item{kappa}{numeric: intensity of Poisson process of settlement cluster centers (for new objects)}

\item{mu}{numeric: mean number of points per settlement cluster (for new objects)}

\item{geometry}{with valid values \code{'point'} (the default, corresponding to point locations), \code{'triangle'},
\code{'square'} and \code{'hexagon'} corresponding to grids constructed from pixels of regular polygons.}
}
\value{
A list of class \code{"CRTsp"} containing the following components:
\tabular{lll}{
\code{design}   \tab list: \tab parameters required for power calculations\cr
\code{geom_full}   \tab list: \tab summary statistics describing the site \cr
\code{geom_core}   \tab list: \tab summary statistics describing the core area
(when a buffer is specified)\cr
\code{trial} \tab data frame: \tab rows correspond to geolocated points, as follows:\cr
\tab \code{x} \tab numeric vector: x-coordinates of locations \cr
\tab \code{y} \tab numeric vector: y-coordinates of locations \cr
\tab \code{cluster} \tab factor: assignments to cluster of each location  \cr
\tab \code{arm} \tab factor: assignments to \code{"control"} or \code{"intervention"} for each location \cr
\tab \code{nearestDiscord} \tab numeric vector: Euclidean distance to nearest discordant location (km) \cr
\tab \code{buffer} \tab logical: indicator of whether the point is within the buffer \cr
\tab \code{...} \tab other objects included in the input \code{"CRTsp"} object or data frame \cr
}
}
\description{
\code{CRTsp} coerces data frames containing co-ordinates and location attributes
into objects of class \code{"CRTsp"} or creates a new \code{"CRTsp"} object by simulating a set of Cartesian co-ordinates for use as the locations in a simulated trial site
}
\details{
If a data frame or \code{"CRTsp"} object is input then the output \code{"CRTsp"} object is validated,
a description of the geography is computed and power calculations are carried out.\cr\cr
If \code{geoscale, locations, kappa} and \code{mu} are specified then a new trial dataframe is constructed
corresponding to a novel simulated human settlement pattern. This is generated using the
Thomas algorithm (\code{rThomas}) in \href{https://CRAN.R-project.org/package=spatstat.random}{\code{spatstat.random}}
allowing the user to defined the density of locations and degree of spatial clustering.
The resulting trial data frame comprises a set of Cartesian coordinates centred at the origin.\cr\cr
}
\examples{
{# Generate a simulated area with 10,000 locations
example_area = CRTsp(geoscale = 1, locations=10000, kappa=3, mu=40)
summary(example_area)
}
}
