% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncvMLM.R
\name{ncvMLM}
\alias{ncvMLM}
\title{Testing for nonconstant variance (ncv)}
\usage{
ncvMLM(mx, bp = TRUE)
}
\arguments{
\item{mx}{The \code{lme} or \code{merMod} model object.}

\item{bp}{Computes a Breusch-Pagan-type test (\code{TRUE}). If \code{FALSE} computes a Levene-type test.}
}
\value{
A p-value (p < .05 suggests heteroskedasticity).
}
\description{
{Function to detect heteroscedasticity in two-level random intercept models.
Uses a generalization of the Breusch-Pagan-type (using squared residuals)
and Levene-type test (using the absolute value of residuals). Note: this will
not tell you if including random slopes are warranted (for that, use the
\code{robust_mixed}) function and compare differences in model-based and
robust standard errors.}
}
\examples{
require(lme4)
data(sch25)
ncvMLM(lmer(math ~ byhomewk + male + ses + (1|schid), data = sch25)) #supported
ncvMLM(lmer(math ~ byhomewk + male + ses + minority + (1|schid), data = sch25)) #hetero
}
\references{
\cite{Huang, F., Wiedermann, W., & Zhang, B. (2022). Accounting for Heteroskedasticity Resulting from Between-group Differences in Multilevel Models. Multivariate Behavioral Research.
}
}
