# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Loglikelihood function for CMP.
#' 
#' @param x Vector of observed counts.
#' @param lambda Vector of lambda parameters.
#' @param nu Vector of nu parameters.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @details
#' The vectors \code{x}, \code{lambda}, and \code{nu} must ne the same length.
#' 
#' @return Value of loglikelihood.
#' 
#' @noRd
loglik_cmp <- function(x, lambda, nu, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_loglik_cmp`, x, lambda, nu, hybrid_tol, truncate_tol, ymax)
}

#' Density function for CMP.
#' 
#' @param x Vector of density arguments.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param take_log Return density on the log-scale if \code{TRUE}. Otherwise,
#' return density on the original scale.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @return Density values.
#' 
#' @noRd
d_cmp <- function(x, lambda, nu, take_log, normalize, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_d_cmp`, x, lambda, nu, take_log, normalize, hybrid_tol, truncate_tol, ymax)
}

#' CDF function for CMP.
#' 
#' @param x Vector of CDF arguments.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param take_log Return CDF value on the log-scale if \code{TRUE}. Otherwise,
#' return value on the original scale.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @return CDF values.
#' 
#' @noRd
p_cmp <- function(x, lambda, nu, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_p_cmp`, x, lambda, nu, hybrid_tol, truncate_tol, ymax)
}

#' Quantile function for CMP.
#' 
#' @param logq Vector of probabilities on the log scale.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @details
#' Operates on the log-scale for stability.
#' 
#' @return Quantile values.
#' 
#' @noRd
q_cmp <- function(logq, lambda, nu, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_q_cmp`, logq, lambda, nu, hybrid_tol, truncate_tol, ymax)
}

#' Draw variates from CMP.
#' 
#' @param n Number of draws to generate.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @return Draws.
#' 
#' @noRd
r_cmp <- function(n, lambda, nu, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_r_cmp`, n, lambda, nu, hybrid_tol, truncate_tol, ymax)
}

#' Compute quantiles of a discrete / finite distribution.
#' 
#' @param q Probability of the desired quantile.
#' @param cp vector of cumulative probabilities.
#' 
#' @details
#' Compute a quantile for the discrete distribution with values
#' \code{0, 1, ..., k-1} and associated *cumulative* probabilities
#' \code{cp(0), cp(1), ..., cp(k-1)}. Use a bisection search in case \code{cp}
#' is a large vector. \code{q} and \code{cp} can be given on the log-scale or
#' probability scale, but they are expected to be compatible.
#' 
#' @return The desired quantile.
#' 
#' @noRd
q_discrete <- function(q, cp) {
    .Call(`_COMPoissonReg_q_discrete`, q, cp)
}

#' Derivatives of the normalizing constant.
#' 
#' @param lambda A vector of lambda parameters.
#' @param nu A vector of nu parameters.
#' @param max Maximum value of y to consider.
#' 
#' @details
#' Derivatives of the normalizing constant computed by truncation.
#' \itemize{
#' \item \code{z_prodlogj} \eqn{\sum_{j=0}^{\text{max}} \log(j!) \lambda^j/((j!)^\nu)}
#' }
#' Several other functions are currently in the code but not used.
#' 
#' @return Vector of results.
#' 
#' @noRd
z_prodlogj <- function(lambda, nu, max) {
    .Call(`_COMPoissonReg_z_prodlogj`, lambda, nu, max)
}

#' Compute normalizing constant by truncating the infinite series.
#' 
#' @param lambda A vector of lambda parameters.
#' @param nu A vector of nu parameters.
#' @param tol Tolerance for truncation.
#' @param take_log Compute value on the log-scale if \code{TRUE}. Otherwise,
#' compute value on the original scale.
#' @param ymax Maximum value of y to consider.
#' 
#' @return Vector of normalizing constant values.
#' 
#' @noRd
z_trunc <- function(lambda, nu, tol, take_log, ymax) {
    .Call(`_COMPoissonReg_z_trunc`, lambda, nu, tol, take_log, ymax)
}

#' An approximation method to compute normalizing constant (Shmueli et al,
#' JRSS-C, 2005).
#' 
#' @param lambda A vector of lambda parameters.
#' @param nu A vector of nu parameters.
#' @param take_log Compute value on the log-scale if \code{TRUE}. Otherwise,
#' compute value on the original scale.
#' 
#' @return Vector of normalizing constant values.
#' @references
#' Galit Shmueli, Thomas P. Minka, Joseph B. Kadane, Sharad Borle, and Peter
#' Boatwright (2005). A useful distribution for fitting discrete data: revival
#' of the Conway-Maxwell-Poisson distribution. Journal of Royal Statistical
#' Society C, 54, 127-142.
#' 
#' @noRd
z_approx <- function(lambda, nu, take_log) {
    .Call(`_COMPoissonReg_z_approx`, lambda, nu, take_log)
}

#' Hybrid method to compute normalizing constant.
#' 
#' @param lambda A vector of lambda parameters.
#' @param nu A vector of nu parameters.
#' @param take_log Return constant on the log-scale if \code{TRUE}. Otherwise,
#' return constant on the original scale.
#' @param hybrid_tol Tolerance for when to use approximation vs. truncation.
#' @param truncate_tol Tolerance for truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @details
#' Conway-Maxwell Poisson normalizing constant is
#' \deqn{
#' Z(\lambda, \nu) = \sum_{j=0}^1 { \lambda^j / (j!)^\nu }.
#' }
#' Hybrid method uses approximation approach when
#' \deqn{
#' \lambda^{-1/\nu}
#' }
#' is smaller than \code{hybrid_tol}.
#' 
#' @return Vector of normalizing constant values.
#' 
#' @noRd
z_hybrid <- function(lambda, nu, take_log, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_z_hybrid`, lambda, nu, take_log, hybrid_tol, truncate_tol, ymax)
}

#' Truncation value computed in \code{z_trunc}. This can be used by other
#' functions to compute truncated expressions.
#' 
#' @param lambda A vector of lambda parameters.
#' @param nu A vector of nu parameters.
#' @param tol Tolerance for truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @return Vector of truncation values used in normalizing constant
#' computation.
#' 
#' @noRd
y_trunc <- function(lambda, nu, tol, ymax) {
    .Call(`_COMPoissonReg_y_trunc`, lambda, nu, tol, ymax)
}

#' Loglikelihood function for ZICMP.
#' 
#' @param x Vector of observed counts.
#' @param lambda Vector of lambda parameters.
#' @param nu Vector of nu parameters.
#' @param p Vector of p parameters.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @details
#' The vectors \code{x}, \code{lambda}, and \code{nu} must ne the same length.
#' 
#' @return Value of loglikelihood.
#' 
#' @noRd
loglik_zicmp <- function(x, lambda, nu, p, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_loglik_zicmp`, x, lambda, nu, p, hybrid_tol, truncate_tol, ymax)
}

#' Density function for ZICMP.
#' 
#' @param x Vector of density arguments.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param p Zero-inflation parameter.
#' @param take_log Return density on the log-scale if \code{TRUE}. Otherwise,
#' return density on the original scale.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @return Density values.
#' 
#' @noRd
d_zicmp <- function(x, lambda, nu, p, take_log, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_d_zicmp`, x, lambda, nu, p, take_log, hybrid_tol, truncate_tol, ymax)
}

#' Quantile function for ZICMP.
#' 
#' @param logq Vector of probabilities on the log scale.
#' @param lambda Rate parameter.
#' @param nu Dispersion parameter.
#' @param p Zero-inflation parameter.
#' @param hybrid_tol Tolerance for truncation.
#' @param truncate_tol Tolerance for when to use approximation vs. truncation.
#' @param ymax Maximum value of y to consider.
#' 
#' @details
#' Operates on the log-scale for stability.
#' 
#' @return Quantile values.
#' 
#' @noRd
q_zicmp <- function(logq, lambda, nu, p, hybrid_tol, truncate_tol, ymax) {
    .Call(`_COMPoissonReg_q_zicmp`, logq, lambda, nu, p, hybrid_tol, truncate_tol, ymax)
}

